/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.outline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.python.pydev.shared_core.model.ErrorDescription;
import org.python.pydev.shared_ui.outline.IParsedItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseParsedItem
implements IParsedItem,
Comparable<Object> {
    protected IParsedItem parent;
    protected IParsedItem[] children;
    protected ErrorDescription errorDesc;
    protected String toStringCache;

    @Override
    public void updateTo(IParsedItem item) {
        IParsedItem updateToItem = item;
        this.toStringCache = null;
        this.errorDesc = updateToItem.getErrorDesc();
        IParsedItem[] newStructureChildren = updateToItem.getChildren();
        if (this.children == null) {
            this.children = newStructureChildren;
            return;
        }
        if (newStructureChildren.length == 0 || this.children.length == 0) {
            this.children = newStructureChildren;
            return;
        }
        ArrayList<IParsedItem> newChildren = new ArrayList<IParsedItem>();
        HashMap<String, List<IParsedItem>> childrensCache = new HashMap<String, List<IParsedItem>>();
        IParsedItem[] iParsedItemArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            IParsedItem existing = iParsedItemArray[n2];
            String s = existing.toString();
            ArrayList<IParsedItem> list = (ArrayList<IParsedItem>)childrensCache.get(s);
            if (list == null) {
                list = new ArrayList<IParsedItem>();
                childrensCache.put(s, list);
            }
            list.add(existing);
            ++n2;
        }
        iParsedItemArray = newStructureChildren;
        n = newStructureChildren.length;
        n2 = 0;
        while (n2 < n) {
            IParsedItem n3 = iParsedItemArray[n2];
            IParsedItem similarChild = this.getSimilarChild(n3, childrensCache);
            if (similarChild != null) {
                similarChild.updateTo(n3);
                n3 = similarChild;
            } else {
                n3.setParent(this);
            }
            newChildren.add(n3);
            ++n2;
        }
        this.children = newChildren.toArray(new IParsedItem[newChildren.size()]);
    }

    @Override
    public void setParent(IParsedItem parsedItem) {
        this.parent = parsedItem;
    }

    private IParsedItem getSimilarChild(IParsedItem n, HashMap<String, List<IParsedItem>> childrensCache) {
        List<IParsedItem> list = childrensCache.get(n.toString());
        if (list != null && list.size() > 0) {
            return list.remove(0);
        }
        return null;
    }

    @Override
    public IParsedItem getParent() {
        return this.parent;
    }

    public String toString() {
        if (this.toStringCache == null) {
            this.toStringCache = this.calcToString();
        }
        return this.toStringCache;
    }

    protected abstract String calcToString();

    @Override
    public ErrorDescription getErrorDesc() {
        return this.errorDesc;
    }

    public void setErrorDesc(ErrorDescription errorDesc) {
        if (this.errorDesc == null && errorDesc == null) {
            return;
        }
        this.toStringCache = null;
        this.errorDesc = errorDesc;
    }
}

