/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.outline;

import java.util.ArrayList;
import org.eclipse.swt.widgets.Display;
import org.python.pydev.shared_core.editor.IBaseEditor;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.model.ErrorDescription;
import org.python.pydev.shared_core.model.IModelListener;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_ui.outline.BaseOutlinePage;
import org.python.pydev.shared_ui.outline.IOutlineModel;
import org.python.pydev.shared_ui.outline.IParsedItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseModel
implements IOutlineModel {
    protected final IBaseEditor editor;
    protected final BaseOutlinePage outline;
    protected final IModelListener modelListener;
    protected IParsedItem root = null;

    protected abstract IParsedItem createParsedItemFromSimpleNode(ISimpleNode var1);

    public BaseModel(BaseOutlinePage outline, IBaseEditor editor) {
        this.editor = editor;
        this.outline = outline;
        this.modelListener = new IModelListener(){

            public void modelChanged(final ISimpleNode ast) {
                Display.getDefault().asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            IParsedItem newRoot = BaseModel.this.createParsedItemFromSimpleNode(ast);
                            BaseModel.this.setRoot(newRoot);
                        }
                    }
                });
            }

            public void errorChanged(final ErrorDescription errorDesc) {
                Display.getDefault().asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        2 var1_1 = this;
                        synchronized (var1_1) {
                            IParsedItem newRoot = BaseModel.this.duplicateRootAddingError(errorDesc);
                            BaseModel.this.setRoot(newRoot);
                        }
                    }
                });
            }
        };
        this.root = this.createInitialRootFromEditor();
        editor.addModelListener(this.modelListener);
    }

    protected abstract IParsedItem createInitialRootFromEditor();

    protected abstract IParsedItem duplicateRootAddingError(ErrorDescription var1);

    @Override
    public void dispose() {
        this.editor.removeModelListener(this.modelListener);
    }

    @Override
    public IParsedItem getRoot() {
        return this.root;
    }

    private void patchRootHelper(IParsedItem oldItem, IParsedItem newItem, ArrayList<IParsedItem> itemsToRefresh, ArrayList<IParsedItem> itemsToUpdate) {
        IParsedItem[] oldChildren;
        IParsedItem[] newChildren = newItem.getChildren();
        if (newChildren.length != (oldChildren = oldItem.getChildren()).length) {
            oldItem.updateTo(newItem);
            itemsToRefresh.add(oldItem);
        } else {
            String newTitle;
            int i = 0;
            while (i < oldChildren.length) {
                this.patchRootHelper(oldChildren[i], newChildren[i], itemsToRefresh, itemsToUpdate);
                ++i;
            }
            String oldTitle = oldItem.toString();
            if (!oldTitle.equals(newTitle = newItem.toString()) || !oldItem.sameNodeType(newItem)) {
                itemsToUpdate.add(oldItem);
            }
            oldItem.updateShallow(newItem);
        }
    }

    public void setRoot(IParsedItem newRoot) {
        try {
            if (this.root != null) {
                ArrayList<IParsedItem> itemsToRefresh = new ArrayList<IParsedItem>();
                ArrayList<IParsedItem> itemsToUpdate = new ArrayList<IParsedItem>();
                this.patchRootHelper(this.root, newRoot, itemsToRefresh, itemsToUpdate);
                if (this.outline != null) {
                    int itemsToRefreshSize;
                    if (this.outline.isDisposed()) {
                        return;
                    }
                    int itemsToUpdateSize = itemsToUpdate.size();
                    if (itemsToUpdateSize > 0) {
                        this.outline.updateItems(itemsToUpdate.toArray(new IParsedItem[itemsToUpdateSize]));
                    }
                    if ((itemsToRefreshSize = itemsToRefresh.size()) > 0) {
                        this.outline.refreshItems(itemsToRefresh.toArray(new IParsedItem[itemsToRefreshSize]));
                    }
                }
            } else {
                Log.log((String)"No old model root?");
            }
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
    }
}

