/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.editor;

import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_ui.editor.BaseEditor;

class BaseEditorCursorListener
implements MouseListener,
KeyListener {
    private final BaseEditor editor;
    private int lastOffset = -1;

    BaseEditorCursorListener(BaseEditor editor) {
        this.editor = editor;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        this.lastOffset = this.getOffset();
        this.editor.notifyCursorPositionChanged();
    }

    public void keyPressed(KeyEvent e) {
    }

    private int getOffset() {
        return ((ITextSelection)this.editor.getSelectionProvider().getSelection()).getOffset();
    }

    public void keyReleased(KeyEvent e) {
        if (e.character == '\u0000') {
            try {
                int offset = this.getOffset();
                if (offset != this.lastOffset) {
                    this.editor.notifyCursorPositionChanged();
                    this.lastOffset = offset;
                }
            }
            catch (Exception ex) {
                Log.log((Throwable)ex);
            }
        }
    }
}

