/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.overview_ruler;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.shared_ui.SharedUiPlugin;

public class MinimapOverviewRulerPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String USE_MINIMAP = "USE_MINIMAP";
    public static final String SHOW_SCROLLBAR = "SHOW_SCROLLBAR";
    public static final String SHOW_MINIMAP_CONTENTS = "SHOW_MINIMAP_CONTENTS";
    public static final String MINIMAP_WIDTH = "MINIMAP_WIDTH";
    private static final int MIN = 1;

    public MinimapOverviewRulerPreferencesPage() {
        super(1);
        this.setPreferenceStore(SharedUiPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        BooleanFieldEditor useMinimap = new BooleanFieldEditor(USE_MINIMAP, "Show minimap? (applied on editor restart)", p);
        this.addField((FieldEditor)useMinimap);
        BooleanFieldEditor showContents = new BooleanFieldEditor(SHOW_MINIMAP_CONTENTS, "Show text in overview ruler? (applied on text change)", p);
        this.addField((FieldEditor)showContents);
        IntegerFieldEditor minimapWidth = new IntegerFieldEditor(MINIMAP_WIDTH, "Minimap Width: (applied on editor resize)", p);
        this.addField((FieldEditor)minimapWidth);
    }

    public static boolean useMinimap() {
        return SharedUiPlugin.getDefault().getPreferenceStore().getBoolean(USE_MINIMAP);
    }

    public static boolean getShowMinimapContents() {
        return SharedUiPlugin.getDefault().getPreferenceStore().getBoolean(SHOW_MINIMAP_CONTENTS);
    }

    public static boolean getShowScrollbar() {
        return true;
    }

    public static int getMinimapWidth() {
        IPreferenceStore preferenceStore = SharedUiPlugin.getDefault().getPreferenceStore();
        int i = preferenceStore.getInt(MINIMAP_WIDTH);
        if (i < 1) {
            i = 1;
        }
        return i;
    }
}

