/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.trinidad.tagsupport.converter.operations;

import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.webtier.trinidad.TrinidadPlugin;
import org.eclipse.jst.pagedesigner.converter.ConvertPosition;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.AbstractTransformOperation;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TableOperation
extends AbstractTransformOperation {
    private static final String CHILD_TEXT_NBSP = "\u00a0";
    private static final String CHILD_TEXT_SEPARATOR = "\u00a0\u00a0|\u00a0\u00a0";
    private static final String ATTR_VALUE_100PERCENT = "100%";
    private static final String ATTR_VALUE_1PERCENT = "1%";
    private static final String ATTR_VALUE_CHECKBOX = "checkbox";
    private static final String ATTR_VALUE_HASHMARK = "#";
    private static final String ATTR_VALUE_KEEPALL = "word-break:keep-all;";
    private static final String ATTR_VALUE_MIDDLE = "middle";
    private static final String ATTR_VALUE_MULTIPLE = "multiple";
    private static final String ATTR_VALUE_NOWRAP = "white-space: nowrap;";
    private static final String ATTR_VALUE_RADIO = "radio";
    private static final String ATTR_VALUE_RIGHT = "right";
    private static final String ATTR_VALUE_SINGLE = "single";
    private static final String ATTR_VALUE_TRUE = "true";
    private static final String ATTR_VALUE_ZERO = "0";
    private static final String FACET_NAME_ACTIONS = "actions";
    private static final String FACET_NAME_DETAILSTAMP = "detailStamp";
    private static final String FACET_NAME_FOOTER = "footer";
    private static final String FACET_NAME_HEADER = "header";
    private static final String TAG_FACET = "facet";
    private RowSelection _rowSelection = RowSelection.NONE;
    private boolean _showDetails = false;
    private boolean _isFirstColumnRowHeader = false;

    public Element transform(Element srcElem, Element curElem) {
        Element divElem = null;
        Attr attribute = srcElem.getAttributeNode("styleClass");
        if (attribute != null) {
            divElem = this.createElement("div");
            divElem.setAttribute("class", attribute.getValue());
        }
        if ((attribute = srcElem.getAttributeNode("inlineStyle")) != null) {
            if (divElem == null) {
                divElem = this.createElement("div");
            }
            divElem.setAttribute("style", attribute.getValue());
        }
        Element mainTable = this.createElement("table");
        mainTable.setAttribute("cellpadding", ATTR_VALUE_ZERO);
        mainTable.setAttribute("cellspacing", ATTR_VALUE_ZERO);
        mainTable.setAttribute("border", ATTR_VALUE_ZERO);
        attribute = srcElem.getAttributeNode("width");
        if (attribute != null) {
            mainTable.setAttribute("width", attribute.getValue());
        }
        Element trElem = this.appendChildElement("tr", mainTable);
        Element tdElem = this.appendChildElement("td", trElem);
        this.buildControlBar(srcElem, tdElem);
        this.buildSubControlBar(srcElem, tdElem);
        Element tableElem = this.appendChildElement("table", tdElem);
        mainTable.setAttribute("cellpadding", ATTR_VALUE_ZERO);
        mainTable.setAttribute("cellspacing", ATTR_VALUE_ZERO);
        mainTable.setAttribute("border", ATTR_VALUE_ZERO);
        tableElem.setAttribute("width", ATTR_VALUE_100PERCENT);
        tableElem.setAttribute("class", "af_table_content");
        this.buildHeader(srcElem, tableElem);
        this.buildBody(srcElem, tableElem);
        this.buildFooter(srcElem, tableElem);
        if (divElem != null) {
            divElem.appendChild(mainTable);
            return divElem;
        }
        return mainTable;
    }

    private void buildControlBar(Element srcElem, Element parent) {
        Element tableElem = this.appendChildElement("table", parent);
        tableElem.setAttribute("cellpadding", ATTR_VALUE_ZERO);
        tableElem.setAttribute("cellspacing", ATTR_VALUE_ZERO);
        tableElem.setAttribute("border", ATTR_VALUE_ZERO);
        tableElem.setAttribute("width", ATTR_VALUE_100PERCENT);
        tableElem.setAttribute("class", "af_table_control-bar-top");
        Element trElem = this.appendChildElement("tr", tableElem);
        Element facetElem = this.getChildFacetByName(srcElem, FACET_NAME_ACTIONS);
        if (facetElem != null) {
            Element actionsTdElem = this.appendChildElement("td", trElem);
            this.tagConverterContext.addChild((Node)facetElem, new ConvertPosition((Node)actionsTdElem, 0));
        }
        Element tdElem = this.appendChildElement("td", trElem);
        tdElem.setAttribute("width", ATTR_VALUE_100PERCENT);
        tdElem = this.appendChildElement("td", trElem);
        tdElem.setAttribute("align", ATTR_VALUE_RIGHT);
        tdElem.setAttribute("valign", ATTR_VALUE_MIDDLE);
        Element innerTableElem = this.appendChildElement("table", tdElem);
        innerTableElem.setAttribute("cellpadding", ATTR_VALUE_ZERO);
        innerTableElem.setAttribute("cellspacing", ATTR_VALUE_ZERO);
        innerTableElem.setAttribute("border", ATTR_VALUE_ZERO);
        trElem = this.appendChildElement("tr", innerTableElem);
        tdElem = this.appendChildElement("td", trElem);
        tdElem.setAttribute("valign", ATTR_VALUE_MIDDLE);
        Element span = this.appendChildElement("span", tdElem);
        span.setAttribute("class", "OraNavBarInactiveLink");
        this.appendChildText(TrinidadPlugin.getResourceString("TableOperation.ControlBar.Previous"), span);
        tdElem = this.appendChildElement("td", trElem);
        Element select = this.appendChildElement("select", tdElem);
        select.setAttribute("class", "AFFieldText");
        int rowNum = 10;
        String rows = srcElem.getAttribute("rows");
        if (rows != null && rows.trim().length() > 0) {
            try {
                rowNum = Integer.parseInt(rows);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        Element option = this.appendChildElement("option", select);
        option = this.appendChildElement("option", select);
        option.setAttribute("selected", ATTR_VALUE_TRUE);
        this.appendChildText("1-" + rowNum, option);
        tdElem = this.appendChildElement("td", trElem);
        tdElem.setAttribute("valign", ATTR_VALUE_MIDDLE);
        tdElem.setAttribute("style", ATTR_VALUE_NOWRAP);
        this.appendChildText(CHILD_TEXT_NBSP, tdElem);
        Element anchor = this.appendChildElement("a", tdElem);
        anchor.setAttribute("href", ATTR_VALUE_HASHMARK);
        anchor.setAttribute("class", "OraNavBarActiveLink");
        this.appendChildText(String.valueOf(TrinidadPlugin.getResourceString("TableOperation.ControlBar.Next")) + rowNum, anchor);
    }

    private void buildSubControlBar(Element srcElem, Element parent) {
        Element anchor;
        String selectionValue = srcElem.getAttribute("rowSelection");
        if (selectionValue != null && selectionValue.trim().length() > 0) {
            if (ATTR_VALUE_SINGLE.equals(selectionValue)) {
                this._rowSelection = RowSelection.SINGLE;
            } else if (ATTR_VALUE_MULTIPLE.equals(selectionValue)) {
                this._rowSelection = RowSelection.MULTIPLE;
            }
        }
        boolean allDetailsEnabled = false;
        Element facet = this.getChildFacetByName(srcElem, FACET_NAME_DETAILSTAMP);
        if (facet != null) {
            this._showDetails = true;
            String enabled = srcElem.getAttribute("allDetailsEnabled");
            if (enabled != null && ATTR_VALUE_TRUE.equals(enabled)) {
                allDetailsEnabled = true;
            }
        }
        if (!allDetailsEnabled && this._rowSelection == RowSelection.NONE) {
            return;
        }
        Element tableElem = this.appendChildElement("table", parent);
        tableElem.setAttribute("cellpadding", ATTR_VALUE_ZERO);
        tableElem.setAttribute("cellspacing", ATTR_VALUE_ZERO);
        tableElem.setAttribute("border", ATTR_VALUE_ZERO);
        tableElem.setAttribute("width", ATTR_VALUE_100PERCENT);
        tableElem.setAttribute("class", "af_table_sub-control-bar");
        Element trElem = this.appendChildElement("tr", tableElem);
        Element tdElem = this.appendChildElement("td", trElem);
        tdElem.setAttribute("valign", ATTR_VALUE_MIDDLE);
        tdElem.setAttribute("style", ATTR_VALUE_NOWRAP);
        if (this._rowSelection == RowSelection.MULTIPLE) {
            anchor = this.appendChildElement("a", tdElem);
            anchor.setAttribute("href", ATTR_VALUE_HASHMARK);
            anchor.setAttribute("class", "OraNavBarActiveLink");
            this.appendChildText(TrinidadPlugin.getResourceString("TableOperation.RowSelection.SelectAll"), anchor);
            this.appendChildText(CHILD_TEXT_SEPARATOR, tdElem);
            anchor = this.appendChildElement("a", tdElem);
            anchor.setAttribute("href", ATTR_VALUE_HASHMARK);
            anchor.setAttribute("class", "OraNavBarActiveLink");
            this.appendChildText(TrinidadPlugin.getResourceString("TableOperation.RowSelection.SelectNone"), anchor);
            if (allDetailsEnabled) {
                this.appendChildText(CHILD_TEXT_SEPARATOR, tdElem);
            }
        }
        if (allDetailsEnabled) {
            anchor = this.appendChildElement("a", tdElem);
            anchor.setAttribute("href", ATTR_VALUE_HASHMARK);
            anchor.setAttribute("class", "OraNavBarActiveLink");
            this.appendChildText(TrinidadPlugin.getResourceString("TableOperation.RowDetails.ShowAllDetails"), anchor);
            this.appendChildText(CHILD_TEXT_SEPARATOR, tdElem);
            anchor = this.appendChildElement("a", tdElem);
            anchor.setAttribute("href", ATTR_VALUE_HASHMARK);
            anchor.setAttribute("class", "OraNavBarActiveLink");
            this.appendChildText(TrinidadPlugin.getResourceString("TableOperation.RowDetails.HideAllDetails"), anchor);
        }
    }

    private void buildHeader(Element srcElem, Element tableElem) {
        String rowHeader;
        Element firstCol;
        Element facetElem = this.getChildFacetByName(srcElem, FACET_NAME_HEADER);
        List columnElementList = this.getChildElements(srcElem, "column");
        if (!columnElementList.isEmpty() && (firstCol = (Element)columnElementList.get(0)) != null && (rowHeader = firstCol.getAttribute("rowHeader")) != null && ATTR_VALUE_TRUE.equals(rowHeader)) {
            this._isFirstColumnRowHeader = true;
        }
        boolean hasColumnHeader = false;
        for (Element columnElem : columnElementList) {
            String text = columnElem.getAttribute("headerText");
            if (text != null && text.trim().length() > 0) {
                hasColumnHeader = true;
                break;
            }
            Element columnFacet = this.getChildFacetByName(columnElem, FACET_NAME_HEADER);
            if (columnFacet == null) continue;
            hasColumnHeader = true;
            break;
        }
        if (facetElem == null && !hasColumnHeader) {
            return;
        }
        if (facetElem != null) {
            Element headerElem = this.appendChildElement("thead", tableElem);
            Element trElem = this.appendChildElement("tr", headerElem);
            Element thElem = this.appendChildElement("th", trElem);
            thElem.setAttribute("class", "af_column_sortable-header-icon-format");
            int colspan = this.getColumnCountDeep(srcElem);
            if (this._rowSelection != RowSelection.NONE) {
                ++colspan;
            }
            if (this._showDetails) {
                ++colspan;
            }
            thElem.setAttribute("colspan", String.valueOf(colspan));
            this.tagConverterContext.addChild((Node)facetElem, new ConvertPosition((Node)thElem, 0));
        }
        if (hasColumnHeader) {
            Element thElem;
            Element columnElem;
            Element trElem = this.appendChildElement("tr", tableElem);
            Iterator itColumnElementList = columnElementList.iterator();
            if (this._isFirstColumnRowHeader) {
                columnElem = (Element)itColumnElementList.next();
                this.buildHeaderCell(columnElem, trElem);
            }
            if (this._rowSelection != RowSelection.NONE) {
                thElem = this.appendChildElement("th", trElem);
                thElem.setAttribute("width", ATTR_VALUE_1PERCENT);
                thElem.setAttribute("class", "af_column_header-icon-format");
                thElem.setAttribute("style", "white-space: nowrap;word-break:keep-all;");
                this.appendChildText(TrinidadPlugin.getResourceString("TableOperation.RowSelection.Select"), thElem);
            }
            if (this._showDetails) {
                thElem = this.appendChildElement("th", trElem);
                thElem.setAttribute("width", ATTR_VALUE_1PERCENT);
                thElem.setAttribute("class", "af_column_header-text");
                thElem.setAttribute("style", "white-space: nowrap;word-break:keep-all;");
                this.appendChildText(TrinidadPlugin.getResourceString("TableOperation.RowDetails.Details"), thElem);
            }
            while (itColumnElementList.hasNext()) {
                columnElem = (Element)itColumnElementList.next();
                this.buildHeaderCell(columnElem, trElem);
            }
        }
    }

    private void buildHeaderCell(Element columnElem, Element trElem) {
        Element thElem = this.appendChildElement("th", trElem);
        thElem.setAttribute("class", "af_column_header-text OraTableBorder0001");
        Element columnFacet = this.getChildFacetByName(columnElem, FACET_NAME_HEADER);
        if (columnFacet != null) {
            this.tagConverterContext.addChild((Node)columnFacet, new ConvertPosition((Node)thElem, 0));
        } else {
            String text = columnElem.getAttribute("headerText");
            if (text != null && text.trim().length() > 0) {
                this.appendChildText(text, thElem);
            }
        }
    }

    private void buildBody(Element srcElem, Element tableElem) {
        Element input;
        Element tdElem;
        Element columnElem;
        Element trElem = this.appendChildElement("tr", tableElem);
        List columnElementList = this.getChildElements(srcElem, "column");
        Iterator itColumnElementList = columnElementList.iterator();
        int index = 0;
        if (this._isFirstColumnRowHeader) {
            columnElem = (Element)itColumnElementList.next();
            this.tagConverterContext.addChild((Node)columnElem, new ConvertPosition((Node)trElem, index++));
        }
        if (this._rowSelection == RowSelection.MULTIPLE) {
            ++index;
            tdElem = this.appendChildElement("td", trElem);
            tdElem.setAttribute("class", "af_tableSelectMany_cell-icon-format OraTableBorder1111");
            input = this.appendChildElement("input", tdElem);
            input.setAttribute("type", ATTR_VALUE_CHECKBOX);
            input.setAttribute("value", ATTR_VALUE_ZERO);
        } else if (this._rowSelection == RowSelection.SINGLE) {
            ++index;
            tdElem = this.appendChildElement("td", trElem);
            tdElem.setAttribute("class", "af_tableSelectOne_cell-icon-format OraTableBorder1111");
            input = this.appendChildElement("input", tdElem);
            input.setAttribute("type", ATTR_VALUE_RADIO);
            input.setAttribute("value", ATTR_VALUE_ZERO);
        }
        if (this._showDetails) {
            ++index;
            tdElem = this.appendChildElement("td", trElem);
            tdElem.setAttribute("class", "af_column_cell-text OraTableBorder1111");
            tdElem.setAttribute("style", ATTR_VALUE_NOWRAP);
            Element div = this.appendChildElement("div", tdElem);
            Element anchor = this.appendChildElement("a", div);
            anchor.setAttribute("href", ATTR_VALUE_HASHMARK);
            anchor.setAttribute("class", "OraLink af_showDetail_disclosure-icon-link");
            Element span = this.appendChildElement("span", anchor);
            span.setAttribute("class", "p_OraHideShowDisclosedSymbol");
            this.appendChildText("\u25bc", span);
            anchor = this.appendChildElement("a", div);
            anchor.setAttribute("href", ATTR_VALUE_HASHMARK);
            anchor.setAttribute("class", "OraNavBarActiveLink");
            this.appendChildText(TrinidadPlugin.getResourceString("TableOperation.RowDetails.Hide"), anchor);
        }
        while (itColumnElementList.hasNext()) {
            columnElem = (Element)itColumnElementList.next();
            this.tagConverterContext.addChild((Node)columnElem, new ConvertPosition((Node)trElem, index++));
        }
        if (this._showDetails) {
            trElem = this.appendChildElement("tr", tableElem);
            tdElem = this.appendChildElement("td", trElem);
            int colspan = this.getColumnCountDeep(srcElem) + 1;
            if (this._rowSelection != RowSelection.NONE) {
                ++colspan;
            }
            tdElem.setAttribute("colspan", String.valueOf(colspan));
            tdElem.setAttribute("class", "af_table_detail OraTableBorder1111");
            Element facet = this.getChildFacetByName(srcElem, FACET_NAME_DETAILSTAMP);
            this.tagConverterContext.addChild((Node)facet, new ConvertPosition((Node)tdElem, 0));
        }
    }

    private void buildFooter(Element srcElem, Element tableElem) {
        Element trElem;
        Element facetElem = this.getChildFacetByName(srcElem, FACET_NAME_FOOTER);
        List columnElementList = this.getChildElements(srcElem, "column");
        boolean hasColumnFooter = false;
        int firstFooter = 0;
        for (Element columnElem : columnElementList) {
            Element columnFacet = this.getChildFacetByName(columnElem, FACET_NAME_FOOTER);
            if (columnFacet != null) {
                hasColumnFooter = true;
                break;
            }
            ++firstFooter;
        }
        if (facetElem == null && !hasColumnFooter) {
            return;
        }
        int firstColspan = firstFooter;
        if (hasColumnFooter) {
            Element columnFacet;
            Element columnElem;
            Element thElem;
            trElem = this.appendChildElement("tr", tableElem);
            Iterator itColumnElementList = columnElementList.iterator();
            if (this._rowSelection != RowSelection.NONE) {
                ++firstColspan;
            }
            if (this._showDetails) {
                ++firstColspan;
            }
            int index = 0;
            if (this._isFirstColumnRowHeader && firstFooter == 0) {
                thElem = this.appendChildElement("th", trElem);
                thElem.setAttribute("class", "af_table_column-footer");
                thElem.setAttribute("colspan", String.valueOf(firstColspan + 1));
                columnElem = (Element)itColumnElementList.next();
                columnFacet = this.getChildFacetByName(columnElem, FACET_NAME_FOOTER);
                if (columnFacet != null) {
                    this.tagConverterContext.addChild((Node)columnFacet, new ConvertPosition((Node)thElem, 0));
                }
            } else if (firstColspan > 0) {
                thElem = this.appendChildElement("th", trElem);
                thElem.setAttribute("class", "af_table_column-footer");
                thElem.setAttribute("colspan", String.valueOf(firstColspan));
                if (facetElem != null) {
                    this.tagConverterContext.addChild((Node)facetElem, new ConvertPosition((Node)thElem, 0));
                }
            }
            while (itColumnElementList.hasNext()) {
                if (index < firstFooter) {
                    itColumnElementList.next();
                    ++index;
                    continue;
                }
                Element tdElem = this.appendChildElement("td", trElem);
                tdElem.setAttribute("class", "af_column_total-text OraTableBorder0001");
                columnElem = (Element)itColumnElementList.next();
                columnFacet = this.getChildFacetByName(columnElem, FACET_NAME_FOOTER);
                if (columnFacet == null) continue;
                this.tagConverterContext.addChild((Node)columnFacet, new ConvertPosition((Node)tdElem, 0));
            }
        }
        if (firstColspan == 0 && facetElem != null) {
            trElem = this.appendChildElement("tr", tableElem);
            Element tdElem = this.appendChildElement("td", trElem);
            tdElem.setAttribute("class", "af_table_column-footer");
            int colspan = this.getColumnCountDeep(srcElem);
            if (this._rowSelection != RowSelection.NONE) {
                ++colspan;
            }
            if (this._showDetails) {
                ++colspan;
            }
            tdElem.setAttribute("colspan", String.valueOf(colspan));
            this.tagConverterContext.addChild((Node)facetElem, new ConvertPosition((Node)tdElem, 0));
        }
    }

    private Element getChildFacetByName(Element srcElem, String facetName) {
        Element element = null;
        List facets = this.getChildElements(srcElem, TAG_FACET);
        for (Element facet : facets) {
            if (!facet.getAttribute("name").equals(facetName)) continue;
            element = facet;
            break;
        }
        return element;
    }

    private int getColumnCountDeep(Element srcElem) {
        List columns = this.getChildElements(srcElem, "column");
        int count = 0;
        for (Element column : columns) {
            int childCount = this.getColumnCountDeep(column);
            if (childCount > 0) {
                count += childCount;
                continue;
            }
            ++count;
        }
        return count;
    }

    private static enum RowSelection {
        NONE,
        SINGLE,
        MULTIPLE;

    }
}

