/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.trinidad.facet;

import java.util.Iterator;
import oracle.eclipse.tools.common.operations.CompoundOperation;
import oracle.eclipse.tools.common.operations.CompoundOperationExecutor;
import oracle.eclipse.tools.common.operations.DeleteFileOperation;
import oracle.eclipse.tools.common.operations.ICompoundOperation;
import oracle.eclipse.tools.common.operations.IOperation;
import oracle.eclipse.tools.common.operations.OperationUtil;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.wtp.webxml.WebXmlUtils;
import oracle.eclipse.tools.webtier.common.services.util.FacetUtil;
import oracle.eclipse.tools.webtier.trinidad.TrinidadPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryFacetUninstallConfig;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationType;
import org.eclipse.jst.jsf.facesconfig.emf.DefaultRenderKitIdType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class TrinidadFacetUninstallDelegate
implements IDelegate {
    private static final String TRINIDAD_SERVLET_NAME = "resources";
    private static final String TRINIDAD_FILTER_NAME = "trinidad";
    private static final String FACES_CONFIG_FILE_NAME = "WEB-INF/faces-config.xml";
    private static final String DEFAULT_RENDER_KIT_ID = "org.apache.myfaces.trinidad.core";

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)480);
        try {
            FacetUtil.uninstallLibraries((LibraryFacetUninstallConfig)((LibraryFacetUninstallConfig)config), (IProgressMonitor)ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)120));
            this.updateWebXml(project, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)120));
            this.updateFacesConfigFile(project, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)120));
            CompoundOperation compoundOperation = new CompoundOperation(Strings.compoundOperationTitle);
            String indexJspFile = String.valueOf(OperationUtil.getWebContentFolderName((IProject)project)) + "/index.jsp";
            if (project.getFile(indexJspFile).exists()) {
                compoundOperation.add((IOperation)new DeleteFileOperation(project, indexJspFile));
            }
            compoundOperation.add((IOperation)new DeleteFileOperation(project, String.valueOf(OperationUtil.getSrcFolderName((IProject)project)) + "/resources/application.properties"));
            CompoundOperationExecutor.executeWithPrompt((IProgressMonitor)ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)120), (ICompoundOperation)compoundOperation);
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    private void updateWebXml(IProject project, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)10);
        try {
            IDOMModel model = WebXmlUtils.getWebXmlModelForEdit((IProject)project);
            model.aboutToChangeModel();
            WebXmlUtils.removeNodes((IDOMModel)model, (String)"servlet", (String)"servlet-name", (String)TRINIDAD_SERVLET_NAME);
            WebXmlUtils.removeNodes((IDOMModel)model, (String)"servlet-mapping", (String)"servlet-name", (String)TRINIDAD_SERVLET_NAME);
            WebXmlUtils.removeNodes((IDOMModel)model, (String)"filter", (String)"filter-name", (String)TRINIDAD_FILTER_NAME);
            WebXmlUtils.removeNodes((IDOMModel)model, (String)"filter-mapping", (String)"filter-name", (String)TRINIDAD_FILTER_NAME);
            WebXmlUtils.saveWebXmlModel((IDOMModel)model);
            model.changedModel();
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)10);
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    private void updateFacesConfigFile(IProject project, IProgressMonitor monitor) throws CoreException {
        FacesConfigArtifactEdit edit = null;
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)10);
        try {
            edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)project, (String)FACES_CONFIG_FILE_NAME);
            if (edit.getFacesConfig() == null) {
                throw new CoreException((IStatus)new Status(4, TrinidadPlugin.getPluginId(), "Non-null FacesConfigArtifactEdit expected"));
            }
            Iterator it = edit.getFacesConfig().getApplication().iterator();
            while (it.hasNext()) {
                Iterator kit = ((ApplicationType)it.next()).getDefaultRenderKitId().iterator();
                while (kit.hasNext()) {
                    if (!((DefaultRenderKitIdType)kit.next()).getTextContent().equals(DEFAULT_RENDER_KIT_ID)) continue;
                    kit.remove();
                }
            }
            edit.save(null);
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)10);
        }
        finally {
            if (edit != null) {
                edit.dispose();
                assert (edit.isDisposed());
                edit = null;
            }
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    private static final class Strings
    extends NLS {
        public static String compoundOperationTitle;

        static {
            Strings.initializeMessages((String)TrinidadFacetUninstallDelegate.class.getName(), Strings.class);
        }

        private Strings() {
        }
    }
}

