/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.trinidad.facet;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.util.wtp.webxml.WebXmlUpdater;
import oracle.eclipse.tools.webtier.common.services.util.FacetUtil;
import oracle.eclipse.tools.webtier.trinidad.TrinidadPlugin;
import oracle.eclipse.tools.webtier.trinidad.facet.TrinidadFacetInstallConfig;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryFacetInstallConfig;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationType;
import org.eclipse.jst.jsf.facesconfig.emf.DefaultRenderKitIdType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class TrinidadFacetInstallDelegate
implements IDelegate {
    private static final String DEFAULT_RENDER_KIT = "org.apache.myfaces.trinidad.core";
    private static final String facesConfigFile = "WEB-INF/faces-config.xml";

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)"", (int)2);
        try {
            try {
                TrinidadFacetInstallConfig cfg = (TrinidadFacetInstallConfig)((Object)config);
                if (cfg.getFacetedProjectWorkingCopy().getProject() == null) {
                    cfg.getFacetedProjectWorkingCopy().setProjectName(project.getName());
                }
                this.setupLibraries(monitor, cfg);
                this.updateFacesConfigFile(project, cfg);
                this.updateWebXml(project, config, monitor);
                this.copyJspTemplates(project, fv, monitor);
            }
            catch (IOException e) {
                LoggingService.logError((Plugin)TrinidadPlugin.getDefault(), (String)e.getLocalizedMessage());
                ProgressMonitorUtil.done((IProgressMonitor)monitor);
            }
            catch (URISyntaxException e) {
                LoggingService.logError((Plugin)TrinidadPlugin.getDefault(), (String)e.getLocalizedMessage());
                ProgressMonitorUtil.done((IProgressMonitor)monitor);
            }
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    private void setupLibraries(IProgressMonitor monitor, LibraryFacetInstallConfig cfg) throws CoreException {
        cfg.getLibraryInstallDelegate().execute(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
    }

    private void updateWebXml(IProject project, Object config, IProgressMonitor monitor) {
        WebXmlUpdater updater = new WebXmlUpdater(project, monitor);
        updater.addFilter("trinidad", "org.apache.myfaces.trinidad.webapp.TrinidadFilter");
        updater.addFilterMapping("trinidad", "org.apache.myfaces.trinidad.webapp.TrinidadFilter", "Faces Servlet");
        updater.addServlet("resources", "org.apache.myfaces.trinidad.webapp.ResourceServlet", "1");
        updater.addServletMapping("resources", "org.apache.myfaces.trinidad.webapp.ResourceServlet", "/adf/*");
    }

    private void updateFacesConfigFile(IProject project, LibraryFacetInstallConfig config) {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)project, (String)facesConfigFile);
            assert (edit.getFacesConfig() != null);
            if (edit == null) {
                TrinidadPlugin.log("Could not load faces config edit", new Exception());
                return;
            }
            FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
            FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
            ApplicationType newApplication = facesConfigFactory.createApplicationType();
            DefaultRenderKitIdType renderKitIdType = facesConfigFactory.createDefaultRenderKitIdType();
            renderKitIdType.setTextContent(DEFAULT_RENDER_KIT);
            newApplication.getDefaultRenderKitId().add((Object)renderKitIdType);
            edit.getFacesConfig().getApplication().add((Object)newApplication);
            edit.save(null);
        }
        finally {
            if (edit != null) {
                edit.dispose();
                assert (edit.isDisposed());
                edit = null;
            }
        }
    }

    private void copyJspTemplates(IProject project, IProjectFacetVersion fv, IProgressMonitor monitor) throws IOException, URISyntaxException, CoreException {
        File templatesWebContentFolder = FacetUtil.getBundleFolder((Plugin)TrinidadPlugin.getDefault(), (String)"templates/new-app/web-app-common/web");
        File projectWebContentFolder = FacetUtil.getWebContentFolder((IProject)project);
        FacetUtil.copyFiles((File)templatesWebContentFolder, (File)projectWebContentFolder, null, (boolean)false, null);
        File templatesSrcFolder = FacetUtil.getBundleFolder((Plugin)TrinidadPlugin.getDefault(), (String)"templates/new-app/web-app-common/src");
        File webProjectSrcFolder = FacetUtil.getWebProjectSrcFolder((IProject)project);
        FacetUtil.copyFiles((File)templatesSrcFolder, (File)webProjectSrcFolder, null, (boolean)false, null);
        FacetUtil.refreshProject((IProject)project);
    }
}

