/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.trinidad.elementedit;

import java.util.List;
import oracle.eclipse.tools.webtier.trinidad.TrinidadPlugin;
import oracle.eclipse.tools.webtier.trinidad.commands.TableDeleteColumnCommand;
import oracle.eclipse.tools.webtier.trinidad.dom.TrinidadDOMUtil;
import oracle.eclipse.tools.webtier.trinidad.elementedit.util.TableUtil;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.ITrinidadConstants;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.elementedit.DefaultTrinidadCoreElementEdit;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.core.internal.tld.IJSFConstants;
import org.eclipse.jst.pagedesigner.actions.single.SelectEditPartAction;
import org.eclipse.jst.pagedesigner.editpolicies.DragMoveEditPolicy;
import org.eclipse.jst.pagedesigner.editpolicies.ElementResizableEditPolicy;
import org.eclipse.jst.pagedesigner.jsf.ui.actions.DeleteHColumnHeaderFooterAction;
import org.eclipse.jst.pagedesigner.jsf.ui.actions.DeleteHeaderFooterAction;
import org.eclipse.jst.pagedesigner.jsf.ui.actions.InsertHColumnHeaderFooterAction;
import org.eclipse.jst.pagedesigner.jsf.ui.actions.InsertHeaderFooterAction;
import org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml.DataTableDeleteColumnHeaderCommand;
import org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml.DataTableDeleteHeaderCommand;
import org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml.DataTableInsertColumnCommand;
import org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml.DataTableInsertColumnHeaderCommand;
import org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml.DataTableInsertHeaderCommand;
import org.eclipse.jst.pagedesigner.jsf.ui.elementedit.request.DeleteHColumnHeaderFooterRequest;
import org.eclipse.jst.pagedesigner.jsf.ui.elementedit.request.DeleteHeaderFooterRequest;
import org.eclipse.jst.pagedesigner.jsf.ui.elementedit.request.InsertHColumnHeaderFooterRequest;
import org.eclipse.jst.pagedesigner.jsf.ui.elementedit.request.InsertHeaderFooterRequest;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;
import org.eclipse.jst.pagedesigner.parts.NodeEditPart;
import org.eclipse.jst.pagedesigner.tableedit.DeleteRowColumnAction;
import org.eclipse.jst.pagedesigner.tableedit.InsertRowColumnAction;
import org.eclipse.jst.pagedesigner.tableedit.TableInsertRequest;
import org.eclipse.jst.pagedesigner.tableedit.TableResizeRequest;
import org.eclipse.jst.pagedesigner.tableedit.TableRowColumnDeleteRequest;
import org.eclipse.jst.pagedesigner.tools.ObjectModeDragTracker;
import org.eclipse.jst.pagedesigner.validation.caret.ActionData;
import org.eclipse.jst.pagedesigner.validation.caret.DefaultPositionRule;
import org.eclipse.jst.pagedesigner.validation.caret.DnDPositionValidator;
import org.eclipse.jst.pagedesigner.validation.caret.DropActionData;
import org.eclipse.jst.pagedesigner.validation.caret.IPositionMediator;
import org.eclipse.jst.pagedesigner.validation.caret.IValidationRule;
import org.eclipse.jst.pagedesigner.validation.caret.Target;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TableElementEdit
extends DefaultTrinidadCoreElementEdit {
    private static final Action EMPTY_ACTION = new Action(){};
    private static final int FAKE_INDEX = -10;

    public void fillContextMenu(IMenuManager contextMenu, Element ele) {
        super.fillContextMenu(contextMenu, ele);
        MenuManager tableMenu = new MenuManager(TrinidadPlugin.getResourceString("ElementEdit.Submenu.Table"));
        ElementEditPart editPart = (ElementEditPart)((IDOMElement)ele).getAdapterFor(EditPart.class);
        tableMenu.add((IAction)EMPTY_ACTION);
        tableMenu.addMenuListener(new IMenuListener((IMenuManager)tableMenu, editPart){
            private final /* synthetic */ IMenuManager val$tableMenu;
            private final /* synthetic */ ElementEditPart val$editPart;
            {
                this.val$tableMenu = iMenuManager;
                this.val$editPart = elementEditPart;
            }

            public void menuAboutToShow(IMenuManager manager) {
                this.val$tableMenu.removeAll();
                TableElementEdit.this.fillTableMenu(this.val$editPart, -10, this.val$tableMenu);
            }
        });
        contextMenu.appendToGroup("org.eclipse.jst.pagedesigner.container", (IContributionItem)tableMenu);
    }

    public boolean fillContainerContextMenu(IMenuManager contextMenu, ElementEditPart elePart, NodeEditPart nodePart, ISelection innerSelection) {
        Element table = (Element)elePart.getModel();
        Node node = (Node)nodePart.getModel();
        TableUtil util = new TableUtil(table);
        Element columnParent = util.findTRColumnParent(node);
        int cellColumn = util.getColumnIndex(columnParent);
        MenuManager tableMenu = new MenuManager(TrinidadPlugin.getResourceString("ElementEdit.Submenu.Table"));
        tableMenu.add((IAction)EMPTY_ACTION);
        tableMenu.addMenuListener(new IMenuListener((IMenuManager)tableMenu, elePart, cellColumn){
            private final /* synthetic */ IMenuManager val$tableMenu;
            private final /* synthetic */ ElementEditPart val$elePart;
            private final /* synthetic */ int val$cellColumn;
            {
                this.val$tableMenu = iMenuManager;
                this.val$elePart = elementEditPart;
                this.val$cellColumn = n;
            }

            public void menuAboutToShow(IMenuManager manager) {
                this.val$tableMenu.removeAll();
                TableElementEdit.this.fillTableMenu(this.val$elePart, this.val$cellColumn, this.val$tableMenu);
            }
        });
        contextMenu.appendToGroup("org.eclipse.jst.pagedesigner.container", (IContributionItem)tableMenu);
        return true;
    }

    private void fillTableMenu(ElementEditPart elePart, int cellColumn, IMenuManager tableMenu) {
        SelectEditPartAction action = SelectEditPartAction.create((String)TrinidadPlugin.getResourceString("ElementEdit.Submenu.Table.SelectTable"), (EditPart)elePart);
        tableMenu.add((IAction)action);
        tableMenu.add((IContributionItem)new Separator());
        InsertRowColumnAction insertColumnBeforeAction = new InsertRowColumnAction(TrinidadPlugin.getResourceString("ElementEdit.Submenu.Table.InsertColumnBefore"), (EditPart)elePart, cellColumn, false, true);
        tableMenu.add((IAction)insertColumnBeforeAction);
        InsertRowColumnAction insertColumnAfterAction = new InsertRowColumnAction(TrinidadPlugin.getResourceString("ElementEdit.Submenu.Table.InsertColumnAfter"), (EditPart)elePart, cellColumn, false, false);
        tableMenu.add((IAction)insertColumnAfterAction);
        tableMenu.add((IContributionItem)new Separator());
        DeleteRowColumnAction deleteColumnAction = new DeleteRowColumnAction(TrinidadPlugin.getResourceString("ElementEdit.Submenu.Table.DeleteColumn"), (EditPart)elePart, cellColumn, false);
        tableMenu.add((IAction)deleteColumnAction);
        tableMenu.add((IContributionItem)new Separator());
        InsertHeaderFooterAction headerAction = new InsertHeaderFooterAction(TrinidadPlugin.getResourceString("ElementEdit.Submenu.InsertTableHeader"), (EditPart)elePart, true);
        tableMenu.add((IAction)headerAction);
        InsertHeaderFooterAction footerAction = new InsertHeaderFooterAction(TrinidadPlugin.getResourceString("ElementEdit.Submenu.InsertTableFooter"), (EditPart)elePart, false);
        tableMenu.add((IAction)footerAction);
        DeleteHeaderFooterAction delHeaderAction = new DeleteHeaderFooterAction(TrinidadPlugin.getResourceString("ElementEdit.Submenu.DeleteTableHeader"), (EditPart)elePart, true);
        tableMenu.add((IAction)delHeaderAction);
        DeleteHeaderFooterAction delFooterAction = new DeleteHeaderFooterAction(TrinidadPlugin.getResourceString("ElementEdit.Submenu.DeleteTableFooter"), (EditPart)elePart, false);
        tableMenu.add((IAction)delFooterAction);
        tableMenu.add((IContributionItem)new Separator());
        InsertHColumnHeaderFooterAction hColHeaderAction = new InsertHColumnHeaderFooterAction(TrinidadPlugin.getResourceString("ElementEdit.Submenu.InsertColumnHeader"), (EditPart)elePart, true);
        tableMenu.add((IAction)hColHeaderAction);
        InsertHColumnHeaderFooterAction hColFooterAction = new InsertHColumnHeaderFooterAction(TrinidadPlugin.getResourceString("ElementEdit.Submenu.InsertColumnFooter"), (EditPart)elePart, false);
        tableMenu.add((IAction)hColFooterAction);
        DeleteHColumnHeaderFooterAction delColHeader = new DeleteHColumnHeaderFooterAction(TrinidadPlugin.getResourceString("ElementEdit.Submenu.DeleteColumnHeader"), (EditPart)elePart, true);
        tableMenu.add((IAction)delColHeader);
        DeleteHColumnHeaderFooterAction delColFooter = new DeleteHColumnHeaderFooterAction(TrinidadPlugin.getResourceString("ElementEdit.Submenu.DeleteColumnFooter"), (EditPart)elePart, false);
        tableMenu.add((IAction)delColFooter);
    }

    public void createEditPolicies(ElementEditPart part) {
        part.installEditPolicy((Object)"Selection Feedback", (EditPolicy)new TableResizePolicy(part));
        part.installEditPolicy((Object)"PrimaryDrag Policy", (EditPolicy)new MyDragMoveEditPolicy());
    }

    public static class MyDragMoveEditPolicy
    extends DragMoveEditPolicy {
        protected IPositionMediator createDropChildValidator(DropRequest r) {
            DropActionData.DropData dropData = this.createDropData(r);
            if (dropData != null) {
                DnDPositionValidator validator = new DnDPositionValidator((ActionData)new DropActionData(6, dropData));
                validator.addRule((IValidationRule)new OnlyColumnsAndFacetsRule(validator.getActionData()));
                return validator;
            }
            return null;
        }

        private static class OnlyColumnsAndFacetsRule
        extends DefaultPositionRule {
            public OnlyColumnsAndFacetsRule(ActionData actionData) {
                super(actionData);
            }

            public boolean isEditable(Target target) {
                if (ITrinidadConstants.TAG_IDENTIFIER_TABLE.isSameTagType(target.getTagWrapper())) {
                    return this.isDataDroppable();
                }
                return true;
            }

            private boolean isDataDroppable() {
                DropActionData dropActionData;
                TagIdentifier tagId;
                ActionData actionData = this.getActionData();
                return actionData instanceof DropActionData && (IJSFConstants.TAG_IDENTIFIER_FACET.isSameTagType(tagId = (TagIdentifier)(dropActionData = (DropActionData)actionData).getDropData().getTagIdentifiers().get(0)) || ITrinidadConstants.TAG_IDENTIFIER_COLUMN.isSameTagType(tagId));
            }
        }
    }

    static class TableResizePolicy
    extends ElementResizableEditPolicy {
        private static final String COLUMN_SELECT_IMAGE_FILE = "column_select.gif";
        ElementEditPart _part;
        Cursor _columnSelectCursor;

        public TableResizePolicy(ElementEditPart part) {
            this._part = part;
        }

        public void deactivate() {
            super.deactivate();
            if (this._columnSelectCursor != null && !this._columnSelectCursor.isDisposed()) {
                this._columnSelectCursor.dispose();
                this._columnSelectCursor = null;
            }
        }

        private Cursor getColumnSelectCursor() {
            if (this._columnSelectCursor == null) {
                Image cursorImage = TrinidadPlugin.getDefault().getImage(COLUMN_SELECT_IMAGE_FILE);
                this._columnSelectCursor = new Cursor(null, cursorImage.getImageData(), 2, 5);
            }
            return this._columnSelectCursor;
        }

        public Command getCommand(Request request) {
            IHTMLGraphicalViewer viewer = (IHTMLGraphicalViewer)this._part.getViewer();
            Element table = (Element)this._part.getIDOMNode();
            if (request instanceof TableResizeRequest) {
                return super.getCommand(request);
            }
            if (request instanceof TableInsertRequest) {
                TableInsertRequest tableInsertRequest = (TableInsertRequest)request;
                if (tableInsertRequest.isRow()) {
                    return null;
                }
                int index = tableInsertRequest.getIndex() + (tableInsertRequest.isBefore() ? 0 : 1);
                return new DataTableInsertColumnCommand(viewer, table, index);
            }
            if (request instanceof InsertHeaderFooterRequest) {
                InsertHeaderFooterRequest req = (InsertHeaderFooterRequest)request;
                boolean isHeader = req.isHeader();
                return new DataTableInsertHeaderCommand(viewer, table, isHeader);
            }
            if (request instanceof DeleteHeaderFooterRequest) {
                DeleteHeaderFooterRequest req = (DeleteHeaderFooterRequest)request;
                boolean isHeader = req.isHeader();
                return new DataTableDeleteHeaderCommand(viewer, table, isHeader);
            }
            if (request instanceof InsertHColumnHeaderFooterRequest) {
                InsertHColumnHeaderFooterRequest req = (InsertHColumnHeaderFooterRequest)request;
                boolean isHeader = req.isHeader();
                return new DataTableInsertColumnHeaderCommand(viewer, table, isHeader);
            }
            if (request instanceof DeleteHColumnHeaderFooterRequest) {
                DeleteHColumnHeaderFooterRequest req = (DeleteHColumnHeaderFooterRequest)request;
                boolean isHeader = req.isHeader();
                return new DataTableDeleteColumnHeaderCommand(viewer, table, isHeader);
            }
            if (request instanceof TableRowColumnDeleteRequest) {
                TableRowColumnDeleteRequest deleteReq = (TableRowColumnDeleteRequest)request;
                if (deleteReq.isRow()) {
                    return null;
                }
                return new TableDeleteColumnCommand(viewer, table, deleteReq.getIndex());
            }
            return super.getCommand(request);
        }

        public Cursor getSelectionToolCursor(Point mouseLocation) {
            if (this.hitTestColumnSelection(mouseLocation)) {
                return this.getColumnSelectCursor();
            }
            return null;
        }

        protected DragTracker getSelectionTracker(LocationRequest request) {
            final Point mouseLocator = request.getLocation();
            if (this.hitTestColumnSelection(mouseLocator)) {
                ObjectModeDragTracker dragTracker = new ObjectModeDragTracker(this.getHost()){

                    protected boolean handleButtonDown(int button) {
                        EditPart retarget;
                        if (button == 1 && (retarget = TableResizePolicy.this.getRetargetSelectionEditPart(mouseLocator)) != null) {
                            this.setSourceEditPart(retarget);
                        }
                        return super.handleButtonDown(button);
                    }
                };
                dragTracker.setDefaultCursor(this.getSelectionToolCursor(mouseLocator));
                return dragTracker;
            }
            return new ObjectModeDragTracker(this.getHost());
        }

        public DragTracker getSelectionDragTracker(LocationRequest request) {
            return this.getSelectionTracker(request);
        }

        public EditPart getRetargetSelectionEditPart(Point mouseLocation) {
            if (this.hitTestColumnSelection(mouseLocation)) {
                GraphicalEditPart editPart = (GraphicalEditPart)this.getHost();
                List children = editPart.getChildren();
                for (GraphicalEditPart child : children) {
                    Node childNode;
                    if (!(child instanceof NodeEditPart) || !TrinidadDOMUtil.isTRColumn(childNode = ((NodeEditPart)child).getDOMNode())) continue;
                    Point relativeMousePointer = mouseLocation.getCopy();
                    IFigure hostFigure = child.getFigure();
                    hostFigure.translateToRelative((Translatable)relativeMousePointer);
                    Rectangle hostBounds = hostFigure.getBounds();
                    if (relativeMousePointer.x < hostBounds.x || relativeMousePointer.x >= hostBounds.x + hostBounds.width) continue;
                    return child;
                }
            }
            return null;
        }

        private boolean hitTestColumnSelection(Point mouseLocation) {
            GraphicalEditPart part = (GraphicalEditPart)this.getHost();
            IFigure panelFigure = part.getFigure();
            Point relativeLocation = mouseLocation.getCopy();
            panelFigure.translateToRelative((Translatable)relativeLocation);
            int yoffsetAbs = Math.abs(panelFigure.getBounds().y - relativeLocation.y);
            return yoffsetAbs <= 4;
        }
    }
}

