/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.java.internal;

import java.util.ArrayList;
import java.util.SortedSet;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraintBehavior;
import org.eclipse.sapphire.java.JavaTypeConstraintService;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeReferenceService;
import org.eclipse.sapphire.services.FactsService;
import org.eclipse.sapphire.services.ReferenceService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class JavaTypeConstraintFactsService
extends FactsService {
    @Text(value="a concrete class")
    private static LocalizableText termConcreteClass;
    @Text(value="an abstract class")
    private static LocalizableText termAbstractClass;
    @Text(value="an interface")
    private static LocalizableText termInterface;
    @Text(value="an annotation")
    private static LocalizableText termAnnotation;
    @Text(value="an enumeration")
    private static LocalizableText termEnumeration;
    @Text(value="Must be {0}")
    private static LocalizableText statementKindOne;
    @Text(value="Must be {0} or {1}")
    private static LocalizableText statementKindTwo;
    @Text(value="Must be {0}, {1} or {2}")
    private static LocalizableText statementKindThree;
    @Text(value="Must be {0}, {1}, {2} or {3}")
    private static LocalizableText statementKindFour;
    @Text(value="Must {0} {1}")
    private static LocalizableText statementTypeOne;
    @Text(value="Must implement or extend one of: {0}")
    private static LocalizableText statementTypeOneOf;
    @Text(value="Must implement or extend all: {0}")
    private static LocalizableText statementTypeAll;
    @Text(value="implement")
    private static LocalizableText verbImplement;
    @Text(value="extend")
    private static LocalizableText verbExtend;
    @Text(value="implement or extend")
    private static LocalizableText verbImplementOrExtend;

    static {
        LocalizableText.init(JavaTypeConstraintFactsService.class);
    }

    protected void facts(SortedSet<String> facts) {
        ArrayList<String> types;
        Property property = (Property)this.context(Property.class);
        JavaTypeConstraintService service = (JavaTypeConstraintService)property.service(JavaTypeConstraintService.class);
        ArrayList<JavaTypeKind> kinds = new ArrayList<JavaTypeKind>(service.kinds());
        if (kinds.size() > 0 && kinds.size() < 5) {
            if (kinds.size() == 1) {
                facts.add(statementKindOne.format(new Object[]{JavaTypeConstraintFactsService.term((JavaTypeKind)((Object)kinds.get(0)))}));
            } else if (kinds.size() == 2) {
                facts.add(statementKindTwo.format(new Object[]{JavaTypeConstraintFactsService.term((JavaTypeKind)((Object)kinds.get(0))), JavaTypeConstraintFactsService.term((JavaTypeKind)((Object)kinds.get(1)))}));
            } else if (kinds.size() == 3) {
                facts.add(statementKindThree.format(new Object[]{JavaTypeConstraintFactsService.term((JavaTypeKind)((Object)kinds.get(0))), JavaTypeConstraintFactsService.term((JavaTypeKind)((Object)kinds.get(1))), JavaTypeConstraintFactsService.term((JavaTypeKind)((Object)kinds.get(2)))}));
            } else if (kinds.size() == 4) {
                facts.add(statementKindFour.format(new Object[]{JavaTypeConstraintFactsService.term((JavaTypeKind)((Object)kinds.get(0))), JavaTypeConstraintFactsService.term((JavaTypeKind)((Object)kinds.get(1))), JavaTypeConstraintFactsService.term((JavaTypeKind)((Object)kinds.get(2))), JavaTypeConstraintFactsService.term((JavaTypeKind)((Object)kinds.get(3)))}));
            }
        }
        if ((types = new ArrayList<String>(service.types())).size() > 0) {
            if (types.size() == 1) {
                String typeName = (String)types.get(0);
                String verb = verbImplementOrExtend.text();
                ReferenceService referenceService = (ReferenceService)property.service(ReferenceService.class);
                if (referenceService != null && referenceService instanceof JavaTypeReferenceService) {
                    JavaType type = null;
                    try {
                        type = ((JavaTypeReferenceService)referenceService).resolve(typeName);
                    }
                    catch (Exception e) {
                        ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                    }
                    if (type != null) {
                        JavaTypeKind k = type.kind();
                        if (k == JavaTypeKind.CLASS || k == JavaTypeKind.ABSTRACT_CLASS) {
                            verb = verbExtend.text();
                        } else if (k == JavaTypeKind.INTERFACE) {
                            boolean allowsClass = false;
                            boolean allowsInterface = false;
                            for (JavaTypeKind kind : kinds) {
                                if (kind == JavaTypeKind.CLASS || kind == JavaTypeKind.ABSTRACT_CLASS) {
                                    allowsClass = true;
                                    continue;
                                }
                                if (kind != JavaTypeKind.INTERFACE) continue;
                                allowsInterface = true;
                            }
                            if (allowsInterface && !allowsClass) {
                                verb = verbExtend.text();
                            } else if (allowsClass && !allowsInterface) {
                                verb = verbImplement.text();
                            }
                        }
                    }
                }
                facts.add(statementTypeOne.format(new Object[]{verb, typeName}));
            } else {
                StringBuilder buf = new StringBuilder();
                for (String type : types) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(type);
                }
                JavaTypeConstraintBehavior behavior = service.behavior();
                if (behavior == JavaTypeConstraintBehavior.AT_LEAST_ONE) {
                    facts.add(statementTypeOneOf.format(new Object[]{buf.toString()}));
                } else if (behavior == JavaTypeConstraintBehavior.ALL) {
                    facts.add(statementTypeAll.format(new Object[]{buf.toString()}));
                } else {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private static String term(JavaTypeKind kind) {
        switch (kind) {
            case CLASS: {
                return termConcreteClass.text();
            }
            case ABSTRACT_CLASS: {
                return termAbstractClass.text();
            }
            case INTERFACE: {
                return termInterface.text();
            }
            case ANNOTATION: {
                return termAnnotation.text();
            }
            case ENUM: {
                return termEnumeration.text();
            }
        }
        throw new IllegalStateException();
    }

    public static final class Condition
    extends ServiceCondition {
        public boolean applicable(ServiceContext context) {
            Property property = (Property)context.find(Property.class);
            return property != null && property.service(JavaTypeConstraintService.class) != null;
        }
    }
}

