/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.api.tools.internal.JavadocTagManager;
import org.eclipse.pde.api.tools.internal.builder.BuilderMessages;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiJavadocTag;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.util.Util;

public class TagValidator
extends ASTVisitor {
    private ArrayList fTagProblems = null;
    private ICompilationUnit fCompilationUnit = null;
    boolean allinterfaces = true;
    boolean isvisible = true;
    Stack fStack = new Stack();

    public TagValidator(ICompilationUnit parent) {
        this.fCompilationUnit = parent;
    }

    public boolean visit(Javadoc node) {
        ASTNode parent = node.getParent();
        if (parent != null) {
            List tags = node.tags();
            this.validateTags(parent, tags);
        }
        return false;
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        int flags = node.getModifiers();
        this.isvisible = !Flags.isPrivate((int)flags) && !Flags.isPackageDefault((int)flags);
        this.fStack.push(new Item(this.getTypeName((ASTNode)node), node.getModifiers(), this.allinterfaces, this.isvisible));
        return true;
    }

    public void endVisit(AnnotationTypeDeclaration node) {
        this.fStack.pop();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean visit(TypeDeclaration node) {
        int flags = node.getModifiers();
        if (node.isInterface() && node.isMemberTypeDeclaration()) {
            if (Flags.isPublic((int)flags)) {
                this.allinterfaces = true;
            }
            if (this.isvisible) {
                switch (node.getParent().getNodeType()) {
                    case 81: {
                        AbstractTypeDeclaration parent = (AbstractTypeDeclaration)node.getParent();
                        if (Flags.isPublic((int)parent.getModifiers())) {
                            this.isvisible = true;
                            break;
                        }
                        if (this.allinterfaces) break;
                        this.isvisible &= !Flags.isPrivate((int)flags) && !Flags.isPackageDefault((int)flags);
                        break;
                    }
                    case 55: {
                        TypeDeclaration parent = (TypeDeclaration)node.getParent();
                        if (parent.isInterface() && Flags.isPublic((int)parent.getModifiers())) {
                            this.isvisible = true;
                            break;
                        }
                        if (this.allinterfaces) break;
                        this.isvisible &= !Flags.isPrivate((int)flags) && !Flags.isPackageDefault((int)flags);
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else {
            this.allinterfaces &= node.isInterface();
            this.isvisible &= !Flags.isPrivate((int)flags) && !Flags.isPackageDefault((int)flags);
        }
        this.fStack.push(new Item(this.getTypeName((ASTNode)node), node.getModifiers(), this.allinterfaces, this.isvisible));
        return true;
    }

    public void endVisit(TypeDeclaration node) {
        this.fStack.pop();
        if (!this.fStack.empty()) {
            Item i = (Item)this.fStack.peek();
            this.allinterfaces = i.allints;
            this.isvisible = i.visible;
        }
    }

    public boolean visit(EnumDeclaration node) {
        int flags = node.getModifiers();
        this.isvisible = !Flags.isPrivate((int)flags) && !Flags.isPackageDefault((int)flags);
        this.fStack.push(new Item(this.getTypeName((ASTNode)node), node.getModifiers(), this.allinterfaces, this.isvisible));
        return true;
    }

    public void endVisit(EnumDeclaration node) {
        this.fStack.pop();
    }

    public void endVisit(CompilationUnit node) {
        this.fStack.clear();
    }

    private void validateTags(ASTNode node, List tags) {
        if (tags.size() == 0) {
            return;
        }
        switch (node.getNodeType()) {
            case 55: {
                TypeDeclaration type = (TypeDeclaration)node;
                this.processTypeNode(type, tags);
                break;
            }
            case 71: {
                Item item = (Item)this.fStack.peek();
                Set supported = this.getSupportedTagNames(64, 16);
                Iterator i = tags.iterator();
                while (i.hasNext()) {
                    TagElement tag = (TagElement)i.next();
                    String tagname = tag.getTagName();
                    if (tagname == null || !JavadocTagManager.ALL_TAGS.contains(tagname) || supported.contains(tagname)) continue;
                    this.processTagProblem(item.typename, tag, 2, 7, 6, BuilderMessages.TagValidator_an_enum);
                }
                break;
            }
            case 72: {
                Item item = (Item)this.fStack.peek();
                Iterator i = tags.iterator();
                while (i.hasNext()) {
                    TagElement tag = (TagElement)i.next();
                    String tagname = tag.getTagName();
                    if (tagname == null || !JavadocTagManager.ALL_TAGS.contains(tagname)) continue;
                    this.processTagProblem(item.typename, tag, 5, 7, 6, BuilderMessages.TagValidator_an_enum_constant);
                }
                break;
            }
            case 81: {
                Item item = (Item)this.fStack.peek();
                Set supported = this.getSupportedTagNames(64, 16);
                Iterator i = tags.iterator();
                while (i.hasNext()) {
                    TagElement tag = (TagElement)i.next();
                    String tagname = tag.getTagName();
                    if (tagname == null || !JavadocTagManager.ALL_TAGS.contains(tagname) || supported.contains(tagname)) continue;
                    this.processTagProblem(item.typename, tag, 2, 7, 6, BuilderMessages.TagValidator_an_annotation);
                }
                break;
            }
            case 31: {
                MethodDeclaration method = (MethodDeclaration)node;
                this.processMethodNode(method, tags);
                break;
            }
            case 82: {
                Item item = (Item)this.fStack.peek();
                Iterator i = tags.iterator();
                while (i.hasNext()) {
                    TagElement tag = (TagElement)i.next();
                    String tagname = tag.getTagName();
                    if (tagname == null || !JavadocTagManager.ALL_TAGS.contains(tagname)) continue;
                    this.processTagProblem(item.typename, tag, 6, 7, 6, BuilderMessages.TagValidator_an_annotation_method);
                }
                break;
            }
            case 23: {
                FieldDeclaration field = (FieldDeclaration)node;
                this.processFieldNode(field, tags);
                break;
            }
        }
    }

    void processTypeNode(TypeDeclaration type, List tags) {
        HashSet<String> processed = new HashSet<String>();
        Item item = (Item)this.fStack.peek();
        Iterator i = tags.iterator();
        while (i.hasNext()) {
            TagElement tag = (TagElement)i.next();
            String tagname = tag.getTagName();
            if (tagname == null || !JavadocTagManager.ALL_TAGS.contains(tagname)) continue;
            if (processed.contains(tagname)) {
                this.processTagProblem(item.typename, tag, 6, 8, 7, null);
            } else {
                boolean visible;
                Set supportedtags = this.getSupportedTagNames(type.isInterface() ? 2 : 1, 16);
                boolean bl = visible = item.allints && item.visible;
                if (!type.isInterface()) {
                    int flags = type.getModifiers();
                    if (!supportedtags.contains(tagname)) {
                        this.processTagProblem(item.typename, tag, 2, 7, 6, BuilderMessages.TagValidator_a_class);
                    } else if (Flags.isPrivate((int)flags)) {
                        this.processTagProblem(item.typename, tag, 2, 7, 6, BuilderMessages.TagValidator_a_private_class);
                    } else if (Flags.isPackageDefault((int)flags)) {
                        this.processTagProblem(item.typename, tag, 2, 7, 6, BuilderMessages.TagValidator_a_package_default_class);
                    } else if (Flags.isAbstract((int)flags) && "@noinstantiate".equals(tagname)) {
                        this.processTagProblem(item.typename, tag, 2, 7, 6, BuilderMessages.TagValidator_an_abstract_class);
                    } else if (Flags.isFinal((int)flags) && "@noextend".equals(tagname)) {
                        this.processTagProblem(item.typename, tag, 2, 7, 6, BuilderMessages.TagValidator_a_final_class);
                    } else if (!item.visible) {
                        this.processTagProblem(item.typename, tag, 2, 7, 6, BuilderMessages.TagValidator_a_class_that_is_not_visible);
                    }
                } else if (!supportedtags.contains(tagname)) {
                    this.processTagProblem(item.typename, tag, 2, 7, 6, BuilderMessages.TagValidator_an_interface);
                } else if (!visible) {
                    this.processTagProblem(item.typename, tag, 2, 7, 6, BuilderMessages.TagValidator_an_interface_that_is_not_visible);
                }
            }
            processed.add(tagname);
        }
    }

    void processFieldNode(FieldDeclaration field, List tags) {
        HashSet<String> processed = new HashSet<String>();
        Item item = (Item)this.fStack.peek();
        Iterator i = tags.iterator();
        while (i.hasNext()) {
            TagElement tag = (TagElement)i.next();
            String tagname = tag.getTagName();
            if (tagname == null || !JavadocTagManager.ALL_TAGS.contains(tagname)) continue;
            if (processed.contains(tagname)) {
                this.processTagProblem(item.typename, tag, 6, 8, 7, null);
            } else {
                int pkind = this.getParentKind((ASTNode)field);
                int flags = field.getModifiers();
                boolean isprivate = Flags.isPrivate((int)flags);
                boolean ispackage = Flags.isPackageDefault((int)flags);
                Set supportedtags = this.getSupportedTagNames(pkind, 8);
                switch (pkind) {
                    case 128: {
                        this.processTagProblem(item.typename, tag, 5, 7, 6, BuilderMessages.TagValidator_annotation_field);
                        break;
                    }
                    case 64: {
                        if (!supportedtags.contains(tagname)) {
                            this.processTagProblem(item.typename, tag, 5, 7, 6, BuilderMessages.TagValidator_enum_field);
                            break;
                        }
                        if (isprivate) {
                            this.processTagProblem(item.typename, tag, 5, 7, 6, BuilderMessages.TagValidator_private_enum_field);
                            break;
                        }
                        if (item.visible) break;
                        this.processTagProblem(item.typename, tag, 5, 7, 6, BuilderMessages.TagValidator_not_visible_enum_field);
                        break;
                    }
                    case 2: {
                        if (!supportedtags.contains(tagname)) {
                            this.processTagProblem(item.typename, tag, 5, 7, 6, BuilderMessages.TagValidator_an_interface_field);
                            break;
                        }
                        if (item.visible && item.allints) break;
                        this.processTagProblem(item.typename, tag, 5, 7, 6, BuilderMessages.TagValidator_not_visible_interface_field);
                        break;
                    }
                    case 1: {
                        if (!supportedtags.contains(tagname)) {
                            this.processTagProblem(item.typename, tag, 5, 7, 6, BuilderMessages.TagValidator_a_field);
                            break;
                        }
                        if (isprivate) {
                            this.processTagProblem(item.typename, tag, 5, 7, 6, BuilderMessages.TagValidator_private_field);
                            break;
                        }
                        if (ispackage) {
                            this.processTagProblem(item.typename, tag, 5, 7, 6, BuilderMessages.TagValidator_a_package_default_field);
                            break;
                        }
                        if (item.visible) break;
                        this.processTagProblem(item.typename, tag, 5, 7, 6, BuilderMessages.TagValidator_a_field_that_is_not_visible);
                        break;
                    }
                }
            }
            processed.add(tagname);
        }
    }

    void processMethodNode(MethodDeclaration method, List tags) {
        int pkind = this.getParentKind((ASTNode)method);
        int mods = method.getModifiers();
        boolean isconstructor = method.isConstructor();
        boolean isstatic = Flags.isStatic((int)mods);
        Item item = (Item)this.fStack.peek();
        Set supportedtags = this.getSupportedTagNames(pkind, isconstructor ? 32 : 4);
        HashSet<String> processed = new HashSet<String>();
        Iterator i = tags.iterator();
        while (i.hasNext()) {
            TagElement tag = (TagElement)i.next();
            String tagname = tag.getTagName();
            if (tagname == null || !JavadocTagManager.ALL_TAGS.contains(tagname)) continue;
            if (processed.contains(tagname)) {
                this.processTagProblem(item.typename, tag, 6, 8, 7, null);
            } else {
                switch (pkind) {
                    case 64: {
                        if (!supportedtags.contains(tagname)) {
                            this.processTagProblem(item.typename, tag, 6, 7, 6, BuilderMessages.TagValidator_an_enum_method);
                            break;
                        }
                        if (Flags.isPrivate((int)mods)) {
                            this.processTagProblem(item.typename, tag, 6, 7, 6, BuilderMessages.TagValidator_private_enum_method);
                            break;
                        }
                        if (Flags.isPackageDefault((int)mods)) {
                            this.processTagProblem(item.typename, tag, 6, 7, 6, BuilderMessages.TagValidator_a_package_default_enum);
                            break;
                        }
                        if (item.visible) break;
                        this.processTagProblem(item.typename, tag, 6, 7, 6, BuilderMessages.TagValidator_not_visible_enum_method);
                        break;
                    }
                    case 2: {
                        if (!supportedtags.contains(tagname)) {
                            this.processTagProblem(item.typename, tag, 6, 7, 6, BuilderMessages.TagValidator_an_interface_method);
                            break;
                        }
                        if (!item.allints || !item.visible) {
                            this.processTagProblem(item.typename, tag, 6, 7, 6, BuilderMessages.TagValidator_not_visible_interface_method);
                            break;
                        }
                        if (Flags.isDefaultMethod((int)mods) || !"@nooverride".equals(tagname)) break;
                        this.processTagProblem(item.typename, tag, 6, 7, 6, BuilderMessages.TagValidator_nondefault_interface_method);
                        break;
                    }
                    case 1: {
                        if (!supportedtags.contains(tagname)) {
                            this.processTagProblem(item.typename, tag, 6, 7, 6, isconstructor ? BuilderMessages.TagValidator_a_constructor : BuilderMessages.TagValidator_a_method);
                            break;
                        }
                        if (Flags.isPrivate((int)mods)) {
                            this.processTagProblem(item.typename, tag, 6, 7, 6, isconstructor ? BuilderMessages.TagValidator_private_constructor : BuilderMessages.TagValidator_private_method);
                            break;
                        }
                        if (Flags.isPackageDefault((int)mods)) {
                            if (isstatic) {
                                this.processTagProblem(item.typename, tag, 6, 7, 6, isconstructor ? BuilderMessages.TagValidator_static_package_constructor : BuilderMessages.TagValidator_a_static_package_default_method);
                                break;
                            }
                            this.processTagProblem(item.typename, tag, 6, 7, 6, isconstructor ? BuilderMessages.TagValidator_a_package_default_constructor : BuilderMessages.TagValidator_a_package_default_method);
                            break;
                        }
                        if ("@nooverride".equals(tagname)) {
                            if (Flags.isFinal((int)mods)) {
                                if (isstatic) {
                                    this.processTagProblem(item.typename, tag, 6, 7, 6, isconstructor ? BuilderMessages.TagValidator_static_final_constructor : BuilderMessages.TagValidator_a_static_final_method);
                                    break;
                                }
                                this.processTagProblem(item.typename, tag, 6, 7, 6, isconstructor ? BuilderMessages.TagValidator_final_constructor : BuilderMessages.TagValidator_a_final_method);
                                break;
                            }
                            if (isstatic) {
                                this.processTagProblem(item.typename, tag, 6, 7, 6, isconstructor ? BuilderMessages.TagValidator_a_static_constructor : BuilderMessages.TagValidator_a_static_method);
                                break;
                            }
                            if (Flags.isFinal((int)this.getParentModifiers((ASTNode)method))) {
                                this.processTagProblem(item.typename, tag, 6, 7, 6, isconstructor ? BuilderMessages.TagValidator_constructor_in_final_class : BuilderMessages.TagValidator_a_method_in_a_final_class);
                                break;
                            }
                            if (item.visible) break;
                            this.processTagProblem(item.typename, tag, 6, 7, 6, isconstructor ? BuilderMessages.TagValidator_not_visible_constructor : BuilderMessages.TagValidator_a_method_that_is_not_visible);
                            break;
                        }
                        if (item.visible) break;
                        this.processTagProblem(item.typename, tag, 6, 7, 6, isconstructor ? BuilderMessages.TagValidator_not_visible_constructor : BuilderMessages.TagValidator_a_method_that_is_not_visible);
                        break;
                    }
                }
            }
            processed.add(tagname);
        }
    }

    Set getSupportedTagNames(int type, int member) {
        IApiJavadocTag[] tags = ApiPlugin.getJavadocTagManager().getTagsForType(type, member);
        if (tags.length > 0) {
            HashSet<String> valid = new HashSet<String>(tags.length, 1.0f);
            int i = 0;
            while (i < tags.length) {
                valid.add(tags[i].getTagName());
                ++i;
            }
            return valid;
        }
        return Collections.EMPTY_SET;
    }

    private int getParentModifiers(ASTNode node) {
        if (node == null) {
            return 0;
        }
        if (node instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration type = (AbstractTypeDeclaration)node;
            return type.getModifiers();
        }
        return this.getParentModifiers(node.getParent());
    }

    private String getTypeName(ASTNode node) {
        return this.getTypeName(node, new StringBuffer());
    }

    private String getTypeName(ASTNode node, StringBuffer buffer) {
        switch (node.getNodeType()) {
            case 15: {
                CompilationUnit unit = (CompilationUnit)node;
                PackageDeclaration packageDeclaration = unit.getPackage();
                if (packageDeclaration != null) {
                    buffer.insert(0, '.');
                    buffer.insert(0, packageDeclaration.getName().getFullyQualifiedName());
                }
                return String.valueOf(buffer);
            }
        }
        if (node instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration typeDeclaration = (AbstractTypeDeclaration)node;
            if (typeDeclaration.isPackageMemberTypeDeclaration()) {
                buffer.insert(0, typeDeclaration.getName().getIdentifier());
            } else {
                buffer.insert(0, typeDeclaration.getName().getFullyQualifiedName());
                buffer.insert(0, '$');
            }
        }
        return this.getTypeName(node.getParent(), buffer);
    }

    private void processTagProblem(String typeName, TagElement tag, int element, int kind, int markerid, String context) {
        if (this.fTagProblems == null) {
            this.fTagProblems = new ArrayList(10);
        }
        int charstart = tag.getStartPosition();
        int charend = charstart + tag.getTagName().length();
        int linenumber = -1;
        try {
            IDocument document = Util.getDocument(this.fCompilationUnit);
            linenumber = document.getLineOfOffset(charstart);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (CoreException coreException) {}
        try {
            IApiProblem problem = ApiProblemFactory.newApiProblem(this.fCompilationUnit.getCorrespondingResource().getProjectRelativePath().toPortableString(), typeName, new String[]{tag.getTagName(), context}, new String[]{"apiMarkerID", "org.eclipse.jdt.internal.core.JavaModelManager.handleId"}, new Object[]{new Integer(markerid), this.fCompilationUnit.getHandleIdentifier()}, linenumber, charstart, charend, 0x20000000, element, kind, 0);
            this.fTagProblems.add(problem);
        }
        catch (JavaModelException javaModelException) {}
    }

    private int getParentKind(ASTNode node) {
        if (node == null) {
            return -1;
        }
        if (node instanceof TypeDeclaration) {
            return ((TypeDeclaration)node).isInterface() ? 2 : 1;
        }
        if (node instanceof AnnotationTypeDeclaration) {
            return 128;
        }
        if (node instanceof EnumDeclaration) {
            return 64;
        }
        return this.getParentKind(node.getParent());
    }

    public IApiProblem[] getTagProblems() {
        if (this.fTagProblems == null) {
            return new IApiProblem[0];
        }
        return this.fTagProblems.toArray(new IApiProblem[this.fTagProblems.size()]);
    }

    class Item {
        String typename;
        int flags;
        boolean allints = false;
        boolean visible = false;

        Item(String name, int flags, boolean ints, boolean vis) {
            this.typename = name;
            this.flags = flags;
            this.allints = ints;
            this.visible = vis;
        }
    }
}

