/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonUtil {
    public static final String ENCODING = "UTF-8";

    public static boolean isCausedBy(Throwable actual, Class causeClass) {
        return CommonUtil.getCause(actual, causeClass) != null;
    }

    public static <T> T getCause(Throwable actual, Class<T> causeClass) {
        if (causeClass.isAssignableFrom(actual.getClass())) {
            return (T)actual;
        }
        if (actual.getCause() == null) {
            return null;
        }
        return CommonUtil.getCause(actual.getCause(), causeClass);
    }

    public static String parseAndRemoveDuplicates(String s, String del) {
        if (s == null) {
            return s;
        }
        List<String> list = CommonUtil.parseString(s, del);
        ArrayList<String> listret = new ArrayList<String>();
        for (String item : list) {
            if (listret.contains(item)) continue;
            listret.add(item);
        }
        return CommonUtil.getSeparatedListOfString(listret, "", "", false, del);
    }

    public static List<String> parseString(String s, String del) {
        return CommonUtil.parseString(s, del, false);
    }

    public static List<String> parseString(String s, String del, boolean ignoreNull) {
        if (s == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (del == null) {
            ret.add(s);
            return ret;
        }
        StringTokenizer token = new StringTokenizer(s, del);
        while (token.hasMoreTokens()) {
            String tokenSingle = token.nextToken();
            boolean toAdd = true;
            if (ignoreNull && "".equals(tokenSingle = tokenSingle.trim())) {
                toAdd = false;
            }
            if (!toAdd) continue;
            ret.add(tokenSingle);
        }
        return ret;
    }

    public static String getSeparatedListOfString(Collection<String> list, String open, String close, boolean singleQuoteElement, String separator) {
        if (list == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(open);
        Iterator<String> it = list.iterator();
        while (it.hasNext()) {
            String item = it.next();
            if (singleQuoteElement) {
                buffer.append("'" + item + "'");
            } else {
                buffer.append(item);
            }
            if (!it.hasNext()) continue;
            buffer.append(separator);
        }
        buffer.append(close);
        return buffer.toString();
    }
}

