/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.clibase.util;

public class TimeUtils {
    public static final long ONE_SECOND = 1000L;
    public static final long SECONDS = 60L;
    public static final long ONE_MINUTE = 60000L;
    public static final long MINUTES = 60L;
    public static final long ONE_HOUR = 3600000L;
    public static final long HOURS = 24L;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_YEAR = 31536000000L;

    private TimeUtils() {
    }

    public static String millisToLongDHMS(long duration) {
        return TimeUtils.millisToLongDHMS(duration, true);
    }

    public static String millisToLongDHMS(long duration, boolean includemillis) {
        if (duration < 0L) {
            return "[Clock not in sync]";
        }
        StringBuffer res = new StringBuffer();
        long temp = 0L;
        if (duration >= 1000L) {
            temp = duration / 31536000000L;
            if (temp > 0L) {
                res.append(temp).append(" year").append(temp > 1L ? "s" : "").append((duration -= temp * 31536000000L) >= 60000L ? ", " : "");
            }
            if ((temp = duration / 86400000L) > 0L) {
                res.append(temp).append(" day").append(temp > 1L ? "s" : "").append((duration -= temp * 86400000L) >= 60000L ? ", " : "");
            }
            if ((temp = duration / 3600000L) > 0L) {
                res.append(temp).append(" hour").append(temp > 1L ? "s" : "").append((duration -= temp * 3600000L) >= 60000L ? ", " : "");
            }
            if ((temp = duration / 60000L) > 0L) {
                duration -= temp * 60000L;
                res.append(temp).append(" minute").append(temp > 1L ? "s" : "");
            }
            if (!res.toString().equals("") && duration >= 1000L) {
                if (includemillis) {
                    res.append(", ");
                } else {
                    res.append(" and ");
                }
            }
            if ((temp = duration / 1000L) > 0L) {
                duration -= temp * 1000L;
                res.append(temp).append(" second").append(temp > 1L ? "s" : "");
            }
            if (includemillis) {
                if (!res.toString().equals("")) {
                    res.append(" and ");
                }
                res.append(duration).append(" ms");
            }
            return res.toString();
        }
        return duration + " ms";
    }
}

