/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.clibase.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import oracle.cloudlogic.javaservice.common.clibase.CommandLine;
import oracle.cloudlogic.javaservice.common.clibase.CommandLineArg;
import oracle.cloudlogic.javaservice.common.clibase.CommonConstants;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.ProcessUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSLUtil
implements CommonConstants {
    static final HostnameVerifier ACCEPT_ALL_HOSTS = new HostnameVerifier(){

        public boolean verify(String s, SSLSession sslSession) {
            Logger.getDEFAULT().printlnWarningI18n("NLS_WARN_ACCEPT_ALL_HOSTS", s);
            return true;
        }
    };
    static final TrustManager[] TRUST_MANAGERS_TRUSTING_ALL = new TrustManager[]{new X509TrustManager(){

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        public void checkServerTrusted(X509Certificate[] certs, String authType) {
            Logger.getDEFAULT().printlnWarningI18n("NLS_WARN_TRUST_ALL_SERVER_CERT");
        }
    }};

    public static void setSSLWithoutKeystore(CommandLine cmd) throws Exception {
        SSLUtil.setSSLWithoutKeystore(cmd, false);
    }

    public static void setSSLWithoutKeystore(CommandLine cmd, boolean onCli) throws Exception {
        boolean acceptAllHosts = cmd.getValueAsBoolean("ignorehostnameverification");
        String truststorePWD = cmd.getArgValue("truststorepassword", "");
        boolean trustServerCert = cmd.getValueAsBoolean("trustservercert");
        CommandLineArg trustPath = cmd.getArgs().get("truststore");
        CommandLineArg trustPathPwd = cmd.getArgs().get("truststorepassword");
        String trustStorePath = cmd.getArgValue("truststore");
        if (!trustServerCert) {
            if (trustStorePath == null) {
                throw new Exception("truststore must be provided when trustservercert is false. You can also specify -trustservercert to be true to trust any server this client is going to connect");
            }
            boolean trustPathSpecified = trustPath != null && !trustStorePath.equals(trustPath.getOptionDefaltValue());
            boolean trustPWdSpecified = trustPathPwd != null && !truststorePWD.equals(trustPathPwd.getOptionDefaltValue());
            CloudUtil.validateInputFile(trustStorePath, "truststore");
            if (trustPathSpecified && !trustPWdSpecified) {
                if (!onCli) {
                    Logger.getDEFAULT().printlnWarning("truststore is specified without a password.");
                } else if (trustPathPwd.prompt()) {
                    truststorePWD = trustPathPwd.getOptionValue();
                }
            }
        } else if (trustStorePath != null) {
            Logger.getDEFAULT().printlnDebug("Ignoring argument:truststore");
        }
        SSLUtil.setSSLWithoutKeystore(trustStorePath, truststorePWD, acceptAllHosts, trustServerCert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSSLWithoutKeystore(String trustStorePath, String truststorePWD, boolean acceptAllHosts, boolean trustServerCert) throws Exception {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        TrustManager[] trustManagers = null;
        if (!trustServerCert) {
            FileInputStream trustStoreStream = null;
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try {
                trustStoreStream = new FileInputStream(trustStorePath);
                trustStore.load(trustStoreStream, truststorePWD.toCharArray());
            }
            finally {
                if (trustStoreStream != null) {
                    ((InputStream)trustStoreStream).close();
                }
            }
            trustManagerFactory.init(trustStore);
            trustManagers = trustManagerFactory.getTrustManagers();
        } else {
            trustManagers = TRUST_MANAGERS_TRUSTING_ALL;
        }
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustManagers, new SecureRandom());
        SSLUtil.setSunSSLContextAndDefaultHostVerifier(sc, acceptAllHosts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSSL(CommandLine cmd, InputStream defKeyStoreIs, String defKeyStorePwd, String defKeyStoreKeyPwd) throws Exception {
        boolean acceptAllHosts = cmd.getValueAsBoolean("ignorehostnameverification");
        String truststorePWD = cmd.getArgValue("truststorepassword", "");
        boolean trustServer = cmd.getValueAsBoolean("trustservercert");
        String trustStorePath = cmd.getArgValue("truststore");
        if (!trustServer) {
            if (trustStorePath == null) {
                throw new Exception("truststore must be provided when trustservercert is false. You can also specify -trustservercert to be true trust any server this client is going to connect");
            }
            CloudUtil.validateInputFile(trustStorePath, "truststore");
        } else if (trustStorePath != null) {
            Logger.getDEFAULT().printlnDebug("Ignoring argument:truststore");
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        if (keyManagerFactory == null) {
            throw new Exception("Unable to get KeyManagerFactory instance");
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        InputStream keystoreStream = null;
        keystoreStream = defKeyStoreIs;
        TrustManager[] trustManagers = null;
        if (!trustServer) {
            FileInputStream trustStoreStream = null;
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try {
                trustStoreStream = new FileInputStream(trustStorePath);
                trustStore.load(trustStoreStream, truststorePWD.toCharArray());
            }
            finally {
                if (trustStoreStream != null) {
                    ((InputStream)trustStoreStream).close();
                }
            }
            trustManagerFactory.init(trustStore);
            trustManagers = trustManagerFactory.getTrustManagers();
        } else {
            trustManagers = TRUST_MANAGERS_TRUSTING_ALL;
        }
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(keystoreStream, defKeyStorePwd.toCharArray());
        SSLContext sc = SSLContext.getInstance("SSL");
        keyManagerFactory.init(keystore, defKeyStoreKeyPwd.toCharArray());
        KeyManager[] keymanagers = keyManagerFactory.getKeyManagers();
        sc.init(keymanagers, trustManagers, new SecureRandom());
        SSLUtil.setSunSSLContextAndDefaultHostVerifier(sc, acceptAllHosts);
    }

    public static List<CommandLineArg> getSSLArguments() {
        ArrayList<CommandLineArg> list = new ArrayList<CommandLineArg>();
        CommandLineArg arg = null;
        arg = new CommandLineArg("ignorehostnameverification", false, new CommandLineArg.BooleanOptionType(), NLSUtil.localizeMessage("NLS_PARAM_SSL_ACCEPT_ALL_HOSTS"));
        list.add(arg);
        arg.setAdvancedOption(true);
        arg.setOptionDefaltValue("false");
        arg.setShortCut("ig");
        ArrayList<CommandLineArg.FileExt> files = new ArrayList<CommandLineArg.FileExt>();
        files.add(CommandLineArg.FileExt.jks);
        arg = new CommandLineArg("trustservercert", false, new CommandLineArg.BooleanOptionType(), NLSUtil.localizeMessage("NLS_PARAM_SSL_TRUST_SERVER_CERT"));
        arg.setOptionDefaltValue("false");
        arg.setAdvancedOption(true);
        arg.setShortCut("tsc");
        list.add(arg);
        arg = new CommandLineArg("truststore", false, new CommandLineArg.FileOptionType(CommandLineArg.CardinalityEnum.one, null, files, false, true), NLSUtil.localizeMessage("NLS_PARAM_SSL_TRUST_STORE"));
        list.add(arg);
        arg.setAdvancedOption(true);
        arg.setShortCut("ts");
        if (ProcessUtil.getENV_DEFAULT_JAVA_HOME() != null) {
            File f = new File(ProcessUtil.getENV_DEFAULT_JAVA_HOME(), "lib/security/cacerts");
            String cacert = null;
            cacert = f.exists() ? f.getAbsolutePath() : new File(ProcessUtil.getENV_DEFAULT_JAVA_HOME(), "jre/lib/security/cacerts").getAbsolutePath();
            arg.setOptionDefaltValue(cacert);
        }
        arg = new CommandLineArg("truststorepassword", false, new CommandLineArg.PasswordType(), "Only for SSL. The password for the truststore specified for truststore");
        arg.setOptionDefaltValue("changeit");
        list.add(arg);
        arg.setHidden(true);
        arg.setAdvancedOption(true);
        arg.setShortCut("tsp");
        return list;
    }

    public static void setSunSSLContextAndDefaultHostVerifier(SSLContext sslContext, boolean acceptAllHost) throws Exception {
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        if (acceptAllHost) {
            HttpsURLConnection.setDefaultHostnameVerifier(ACCEPT_ALL_HOSTS);
        }
    }
}

