/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.clibase.display;

import java.util.ArrayList;
import java.util.List;
import oracle.cloudlogic.javaservice.common.clibase.display.Cell;
import oracle.cloudlogic.javaservice.common.clibase.display.Grid;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderCell
extends Cell {
    private int width;

    public HeaderCell() {
        this.setCenterAlign(true);
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void incrementWidth() {
        ++this.width;
    }

    public void decrementWidth() {
        --this.width;
    }

    @Override
    public void setContent(String content) {
        super.setContent(content);
        this.width = content.length();
    }

    public int getWidth() {
        return this.width;
    }

    public List<String> getAsTitleString(int width, boolean verticalAlign) {
        this.setWidth(width);
        this.cutWithWidth(width, verticalAlign);
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        buf.append(Grid.TAB_LEFT_TOP);
        buf.append(CloudUtil.padChar(width, Grid.TITLE_HORIZONTAL, "", width, true));
        buf.append(Grid.TAB_RIGHT_TOP);
        list.add(buf.toString());
        for (int i = 0; i < this.getLinesCount(); ++i) {
            list.add(Grid.TITLE_VERTICAL + this.getLine(i, width) + Grid.TITLE_VERTICAL);
        }
        return list;
    }
}

