/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.spi.config.factory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import oracle.cloud.scanning.api.config.IClassConfiguration;
import oracle.cloud.scanning.api.config.IConfiguration;
import oracle.cloud.scanning.api.config.IFileConfiguration;
import oracle.cloud.scanning.config.imp.ClassConfigurationProvider;
import oracle.cloud.scanning.config.imp.FileConfigurationProvider;
import oracle.cloud.scanning.nls.ScanningApiBundle;
import oracle.cloud.scanning.spi.config.provider.ConfigurationProvider;
import oracle.cloud.scanning.types.Configuration;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public final class ConfigurationFactory {
    private static final String Config_Path_at_domain = "/domains/wlsaas/cloud-whitelist-config.xml";
    private static final String Config_Path = "/config/configuration.xml";
    private static final String Version_Path = "/config/wl-version.properties";
    private static final String WL_CONFIG_VERSION_PROP = "CONFIG-VERSION";
    private static final String WL_VERSION_PROP = "WHITELIST-VERSION";
    private static final ConfigurationFactory impl;

    private ConfigurationFactory() {
    }

    private static InputStream getDefaultConfigurationInputStream() {
        InputStream in = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    if (new File(ConfigurationFactory.Config_Path_at_domain).exists()) {
                        return new FileInputStream(ConfigurationFactory.Config_Path_at_domain);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                return null;
            }
        });
        if (in != null) {
            return in;
        }
        return ConfigurationFactory.class.getResourceAsStream(Config_Path);
    }

    public static ConfigurationFactory getInstance() {
        return impl;
    }

    public IFileConfiguration getDefaultFileConfiguration() {
        return this.getDefaultConfiguration(new FileConfigurationProvider(null));
    }

    public IClassConfiguration getDefaultClassConfiguration() {
        return this.getDefaultConfiguration(new ClassConfigurationProvider(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IConfiguration> T getConfiguration(InputStream config, ConfigurationProvider<T> provider) {
        InputStream versionin = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Configuration.class});
            T conf = provider.createConfiguration((Configuration)CloudUtil.deSerialize(jaxbContext, ConfigurationFactory.class.getClassLoader(), config));
            String configversion = conf.getVersion();
            String toolversion = null;
            String toolconfigversion = null;
            versionin = this.getClass().getResourceAsStream(Version_Path);
            if (configversion == null) {
                configversion = "";
            }
            if (versionin != null) {
                Properties p = new Properties();
                p.load(versionin);
                toolversion = p.getProperty(WL_VERSION_PROP);
                toolconfigversion = p.getProperty(WL_CONFIG_VERSION_PROP);
                Logger logger = Logger.getDEFAULT();
                synchronized (logger) {
                    Logger.getDEFAULT().printlnDebug("");
                    Logger.getDEFAULT().printlnDebug("-------------Version-------------");
                    Logger.getDEFAULT().printlnDebug("Tool Version:" + toolversion);
                    Logger.getDEFAULT().printlnDebug("Tool Configuration Version:" + toolconfigversion);
                    Logger.getDEFAULT().printlnDebug("XML Configuration Version:" + configversion);
                    Logger.getDEFAULT().printlnDebug("-------------Version-------------");
                    Logger.getDEFAULT().printlnDebug("");
                }
            } else {
                Logger.getDEFAULT().printlnWarning("The resource /config/wl-version.properties is not found.");
            }
            if (!configversion.equals(toolconfigversion)) {
                Logger.getDEFAULT().printlnWarningI18n("NLS_VERSION_DOES_NOT_MATCH", toolconfigversion, configversion);
            }
            T t = conf;
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (versionin != null) {
                try {
                    versionin.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IConfiguration> T getDefaultConfiguration(ConfigurationProvider<T> provider) {
        InputStream in = ConfigurationFactory.getDefaultConfigurationInputStream();
        if (in == null) {
            throw new RuntimeException("Resource /config/configuration.xml could not be found.");
        }
        T t = this.getConfiguration(in, provider);
        return t;
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
    }

    static {
        NLSUtil.addBundle(ScanningApiBundle.class.getName(), ConfigurationFactory.class.getClassLoader());
        impl = new ConfigurationFactory();
    }
}

