/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.services;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Properties;
import oracle.cloud.scanning.api.LoggingListener;
import oracle.cloud.scanning.api.Scanner;
import oracle.cloud.scanning.spi.ScannerFactory;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import oracle.cloudlogic.javaservice.common.utils.ApplicationValidator;

public class ApplicationPreProcessorImpl
implements ApplicationValidator {
    @Override
    public String getName() {
        return "whitelist";
    }

    @Override
    public String getLogContentType() {
        return "text/pain";
    }

    @Override
    public void process(InputStream app, String name, OutputStream log, Properties props) throws Exception {
        String w;
        boolean grid = false;
        int gridWidthMax = 180;
        if (props != null && (grid = Boolean.valueOf(props.getProperty("GRID")).booleanValue()) && (w = props.getProperty("GRIDWIDTH")) != null) {
            try {
                gridWidthMax = Integer.parseInt(w);
            }
            catch (Exception e) {
                Logger.getDEFAULT().printlnThrowable(e);
            }
        }
        Scanner scanner = ScannerFactory.getDefaultScanner();
        PrintWriter pr = new PrintWriter(log, true);
        LoggingListener listener = new LoggingListener(pr, grid, gridWidthMax);
        scanner.scan(name, app, listener);
        pr.flush();
        pr.close();
        if (listener.getTotalFailures() != 0L) {
            throw new Exception("whitelist validation has failed.");
        }
    }

    @Override
    public float getProcessingOrder() {
        return 1.0f;
    }
}

