/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.scanner;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.cloud.scanning.FailedResultWrapper;
import oracle.cloud.scanning.api.config.IXMLFileConfiguration;
import oracle.cloud.scanning.api.config.MissingXMLNodeResult;
import oracle.cloud.scanning.api.config.Result;
import oracle.cloud.scanning.api.config.XMLElementResult;
import oracle.cloud.scanning.scanner.AbstractValidator;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.XMLUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLFileValidator
extends AbstractValidator {
    private IXMLFileConfiguration xml;
    static final String LINE_NUMBER_KEY_NAME = "ATTR_LINE_NUMBER_INTERnal";

    public XMLFileValidator(IXMLFileConfiguration xml, InputStream source, String path) {
        super(source, path);
        this.xml = xml;
    }

    public List<FailedResultWrapper> processElement(Element elem) throws Exception {
        Result elVal;
        String lineNo = elem.getAttribute(LINE_NUMBER_KEY_NAME);
        elem.removeAttribute(LINE_NUMBER_KEY_NAME);
        ArrayList<FailedResultWrapper> ret = new ArrayList<FailedResultWrapper>();
        Logger.getDEFAULT().printlnDebug("Processing :" + elem.getNodeName());
        XMLElementResult r = this.xml.checkXMLElement(elem);
        if (!r.isAllowed()) {
            ret.add(new FailedResultWrapper(r, lineNo));
        }
        List<MissingXMLNodeResult> missing = this.xml.checkMissingNodes(elem);
        for (MissingXMLNodeResult node : missing) {
            ret.add(new FailedResultWrapper(node, lineNo));
        }
        if (!r.isToProcessFurther()) {
            return ret;
        }
        for (int i = 0; i < elem.getAttributes().getLength(); ++i) {
            Result att = this.xml.checkAttribute(elem, elem.getAttributes().item(i).getNodeName());
            if (!att.isAllowed()) {
                ret.add(new FailedResultWrapper(att, lineNo));
                continue;
            }
            Result attVal = this.xml.checkAttributeValue(elem, elem.getAttributes().item(i).getNodeName(), elem.getAttributes().item(i).getNodeValue());
            if (attVal.isAllowed()) continue;
            ret.add(new FailedResultWrapper(attVal, lineNo));
        }
        List<Element> list = XMLUtil.getAllFirstChildElements(elem);
        for (Element e : list) {
            ret.addAll(this.processElement(e));
        }
        if (list.isEmpty() && !(elVal = this.xml.checkXMLElementValue(elem, elem.getTextContent())).isAllowed()) {
            ret.add(new FailedResultWrapper(elVal, lineNo));
        }
        return ret;
    }

    @Override
    public List<FailedResultWrapper> validate() throws Exception {
        Document doc = XMLUtil.getStreamAsDocumentWithLineNumbers(new ByteArrayInputStream(CloudUtil.readAllFrom(this.source, false)));
        return this.processElement(doc.getDocumentElement());
    }
}

