/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.scanner;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import oracle.cloud.scanning.FailedResultWrapper;
import oracle.cloud.scanning.api.config.IPropertyFileConfiguration;
import oracle.cloud.scanning.api.config.MissingPropertyResult;
import oracle.cloud.scanning.api.config.Result;
import oracle.cloud.scanning.scanner.AbstractValidator;

public class PropertyFileValidator
extends AbstractValidator {
    private IPropertyFileConfiguration prop;

    public PropertyFileValidator(IPropertyFileConfiguration prop, InputStream source, String path) {
        super(source, path);
        this.prop = prop;
    }

    @Override
    public List<FailedResultWrapper> validate() throws Exception {
        ArrayList<FailedResultWrapper> list = new ArrayList<FailedResultWrapper>();
        Properties props = new Properties();
        props.load(this.source);
        HashMap<Object, Object> map = new HashMap<Object, Object>(props);
        List<MissingPropertyResult> missings = this.prop.checkMissingKeys(map.keySet());
        for (MissingPropertyResult r : missings) {
            list.add(new FailedResultWrapper(r));
        }
        for (String key : map.keySet()) {
            Result r = this.prop.checkKey(key);
            if (!r.isAllowed()) {
                list.add(new FailedResultWrapper(r));
            }
            if ((r = this.prop.checkValue(key, (String)map.get(key))).isAllowed()) continue;
            list.add(new FailedResultWrapper(r));
        }
        return list;
    }
}

