/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.scanner;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.cloud.scanning.FailedResultWrapper;
import oracle.cloud.scanning.api.Listener;
import oracle.cloud.scanning.api.config.IArchiveConfiguration;
import oracle.cloud.scanning.api.config.MissingResourceResult;
import oracle.cloud.scanning.config.generator.IncrementalScansetAdapter;
import oracle.cloud.scanning.scanner.AbstractScanner;

public class JarFileScanner
extends AbstractScanner {
    public JarFileScanner(InputStream in, String path, Listener out, IncrementalScansetAdapter conf) {
        super(in, path, out, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scan() throws Exception {
        ArrayList<FailedResultWrapper> list = new ArrayList<FailedResultWrapper>();
        ArrayList<String> resources = new ArrayList<String>();
        ZipInputStream jarStream = null;
        try {
            this.listener.onZipStart(this.path);
            jarStream = new ZipInputStream(this.in);
            ZipEntry innerEntry = jarStream.getNextEntry();
            while (innerEntry != null) {
                if (!innerEntry.isDirectory()) {
                    resources.add(innerEntry.getName());
                    JarFileScanner.process(jarStream, innerEntry.getName(), this.listener, this.conf);
                }
                innerEntry = jarStream.getNextEntry();
            }
        }
        finally {
            IArchiveConfiguration archive = this.conf.checkArchiveConfiguration(this.path);
            if (archive != null) {
                List<MissingResourceResult> result = archive.checkMissingResourcePaths(resources);
                for (MissingResourceResult r : result) {
                    list.add(new FailedResultWrapper(r));
                }
            }
            this.listener.onZipEnd(list);
        }
    }
}

