/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.scanner;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cloud.common.introspection.api.FailedReference;
import oracle.cloud.common.introspection.model.Type;
import oracle.cloud.scanning.api.Failure;
import oracle.cloud.scanning.api.Listener;
import oracle.cloud.scanning.api.config.ClassReferenceResult;
import oracle.cloud.scanning.api.config.ClassToBeScannedResult;
import oracle.cloud.scanning.api.config.Result;
import oracle.cloud.scanning.config.generator.IncrementalScansetAdapter;
import oracle.cloud.scanning.config.imp.ConfigurationImpl;
import oracle.cloud.scanning.scanner.AbstractScanner;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class ClassFileScanner
extends AbstractScanner {
    public ClassFileScanner(InputStream in, String path, Listener out, IncrementalScansetAdapter conf) {
        super(in, path, out, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scan() throws Exception {
        List<FailedReference> list = null;
        try {
            this.listener.onScanning(this.path);
            Map<String, Pattern> usedPackages = null;
            Type type = this.conf.parseClassFile(this.in);
            Result res = this.conf.checkClassToBeScanned(type.getClassDescription().getFullyQualifiedClassName());
            IncrementalScansetAdapter adapter = new IncrementalScansetAdapter(this.conf, true);
            list = adapter.scanType(type);
            usedPackages = adapter.getUsagesRxPatternMap();
            if (!res.isAllowed()) {
                List<String> excludeDependenciesRx;
                ArrayList<FailedReference> usagelist = new ArrayList<FailedReference>();
                for (FailedReference ref : list) {
                    ClassReferenceResult classref;
                    if (!ClassReferenceResult.class.isAssignableFrom(ref.getResult().getClass()) || (classref = (ClassReferenceResult)ref.getResult()).isToBeExempted()) continue;
                    classref.resetToExemptSeverity();
                    usagelist.add(ref);
                }
                list = usagelist;
                HashSet<String> allpackages = new HashSet<String>();
                if (ClassToBeScannedResult.class.isAssignableFrom(res.getClass()) && (excludeDependenciesRx = ((ClassToBeScannedResult)res).getExcludeDependensies()) != null) {
                    allpackages.addAll(excludeDependenciesRx);
                }
                for (String s : allpackages) {
                    Pattern p = ConfigurationImpl.getPattern(s);
                    usedPackages.put(s, p);
                }
            }
            try {
                this.listener.onClassStart(type.getClassDescription().getFullyQualifiedClassName(), !res.isAllowed(), !res.isAllowed() && list.isEmpty());
            }
            finally {
                Map<String, Pattern> newset = this.listener.onClassEnd(usedPackages);
                if (!res.isAllowed()) {
                    this.conf.addExludedAdditionalPackages(newset);
                }
            }
            if (list == null || list.isEmpty()) {
                this.listener.onScanSuccess();
            } else {
                this.listener.onScanFailure(list);
            }
        }
        catch (Exception e) {
            Logger.getDEFAULT().printlnDebug("Skipped:" + e.getMessage());
        }
        finally {
            if (list == null || list.isEmpty()) {
                this.listener.onScanSuccess();
            } else {
                this.listener.onScanFailure((List<? extends Failure>)list);
            }
        }
    }
}

