/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.scanner;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import oracle.cloud.scanning.WhitelistConnstants;
import oracle.cloud.scanning.api.Listener;
import oracle.cloud.scanning.config.generator.IncrementalScansetAdapter;
import oracle.cloud.scanning.scanner.ClassFileScanner;
import oracle.cloud.scanning.scanner.DirectoryScanner;
import oracle.cloud.scanning.scanner.EarFileScanner;
import oracle.cloud.scanning.scanner.FileScanner;
import oracle.cloud.scanning.scanner.JarFileScanner;
import oracle.cloud.scanning.scanner.WarFileScanner;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public abstract class AbstractScanner
implements WhitelistConnstants {
    protected InputStream in;
    protected String path;
    protected Listener listener;
    protected IncrementalScansetAdapter conf;

    public AbstractScanner(InputStream in, String path, Listener listner, IncrementalScansetAdapter conf) {
        this.listener = listner;
        this.in = in;
        this.conf = conf;
        this.path = path;
    }

    public abstract void scan() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void process(InputStream inStream, String path, Listener listener, IncrementalScansetAdapter conf) {
        block15: {
            Object scanner = null;
            try {
                Logger.getDEFAULT().printlnDebug("Processing:" + path);
                if (inStream == null) {
                    if (new File(path).isFile()) {
                        FileInputStream fin = null;
                        try {
                            fin = new FileInputStream(path);
                            AbstractScanner.scanAsFile(true, fin, path, listener, conf);
                            break block15;
                        }
                        finally {
                            if (fin != null) {
                                fin.close();
                            }
                        }
                    }
                    if (!new File(path).isDirectory()) {
                        InputStream fin = null;
                        try {
                            fin = new URL(path).openConnection().getInputStream();
                            AbstractScanner.scanAsFile(true, fin, path, listener, conf);
                            break block15;
                        }
                        finally {
                            if (fin != null) {
                                fin.close();
                            }
                        }
                    }
                    new DirectoryScanner(path, listener, conf).scan();
                    break block15;
                }
                AbstractScanner.scanAsFile(false, inStream, path, listener, conf);
            }
            catch (Exception e) {
                Logger.getDEFAULT().printlnError(e.getMessage());
                Logger.getDEFAULT().printlnThrowable(e);
            }
        }
    }

    public static void scanAsFile(boolean firstFile, InputStream filestream, String path, Listener listener, IncrementalScansetAdapter conf) throws Exception {
        AbstractScanner scanner = null;
        if (conf.checkFilePath(path).isAllowed()) {
            if (path.toLowerCase().endsWith(".jar")) {
                scanner = new JarFileScanner(filestream, path, listener, conf);
            } else if (path.toLowerCase().endsWith(".war")) {
                scanner = new WarFileScanner(filestream, path, listener, conf);
            } else if (path.toLowerCase().endsWith(".ear")) {
                scanner = new EarFileScanner(filestream, path, listener, conf);
            } else if (path.toLowerCase().endsWith(".class")) {
                scanner = new ClassFileScanner(filestream, path, listener, conf);
            }
        }
        if (scanner == null) {
            scanner = new FileScanner(path, filestream, listener, conf);
            if (firstFile) {
                Logger.getDEFAULT().printlnWarningI18n("NLS_WARN_NON_ARCHIVE");
            }
        }
        scanner.scan();
    }
}

