/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.impl.validation;

import java.util.List;
import javax.xml.namespace.QName;
import oracle.cloud.scanning.api.validation.XMLElementValidator;
import oracle.cloud.scanning.types.IncludesAndExcludes;
import oracle.cloud.scanning.types.Properties;
import oracle.cloudlogic.javaservice.common.clibase.util.XMLUtil;
import org.w3c.dom.Element;

public class AuthConstraintValidator
implements XMLElementValidator {
    @Override
    public boolean validate(Element seccol, IncludesAndExcludes config, Properties properties) {
        List<Element> authmethods = XMLUtil.getAllFirstChildElements(seccol.getOwnerDocument().getDocumentElement(), new QName[]{new QName(seccol.getNamespaceURI(), "login-config"), new QName(seccol.getNamespaceURI(), "auth-method")});
        if (!authmethods.isEmpty()) {
            Element authmethod = authmethods.get(0);
            String val = authmethod.getTextContent();
            if (val != null) {
                val = val.trim();
            }
            if (!"CLIENT-CERT".equalsIgnoreCase(val)) {
                return false;
            }
        } else {
            return false;
        }
        List<Element> list = XMLUtil.getAllFirstChildElements(seccol.getOwnerDocument().getDocumentElement(), new QName(seccol.getNamespaceURI(), "security-constraint"));
        if (list.size() == 1) {
            return true;
        }
        boolean atleastonewithoutauthcontstraint = false;
        for (Element sc : list) {
            List<Element> ac = XMLUtil.getAllFirstChildElements(sc, new QName(seccol.getNamespaceURI(), "auth-constraint"));
            if (ac.size() != 0) continue;
            atleastonewithoutauthcontstraint = true;
            break;
        }
        return !atleastonewithoutauthcontstraint;
    }
}

