/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.impl.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import sun.reflect.Reflection;

public class ReflectionUtil {
    private static Method error_method = null;
    private static final Logger logger = Logger.getLogger(ReflectionUtil.class.getName());
    private static final SecurityManager sm = System.getSecurityManager();
    private static Object NonCatalogLogger = null;
    private static Object NonCatalogLogger_red_alert = null;

    public static void checkSecurityManager() {
        if (System.getSecurityManager() == null && sm != null) {
            AccessControlException ac = new AccessControlException("JCS Security sandbox is broken. Current Security Manager = " + System.getSecurityManager() + " Original = " + sm);
            ReflectionUtil.logRedAlert(ac.getMessage(), ac);
            throw ac;
        }
    }

    public static void checkStackDepth() {
        Class caller = AccessController.doPrivileged(new PrivilegedAction<Class>(){

            @Override
            public Class run() {
                try {
                    int alertrootIndex = 4;
                    Class cls = null;
                    do {
                        cls = Reflection.getCallerClass((int)alertrootIndex);
                        ++alertrootIndex;
                    } while (cls != ReflectionUtil.class);
                    cls = Reflection.getCallerClass((int)(alertrootIndex + 1));
                    while (cls == ReflectionUtil.class) {
                        cls = Reflection.getCallerClass((int)(++alertrootIndex));
                    }
                    if (cls.getName().startsWith("oracle.cloud.jcs.") || cls.getName().startsWith("oracle.cloud.scanning.")) {
                        return null;
                    }
                    return cls;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        if (caller != null) {
            AccessControlException ac = new AccessControlException("Caller " + caller.getName() + "  not allowed to call this method.");
            ReflectionUtil.log(ac.getMessage(), ac);
            throw ac;
        }
        ReflectionUtil.checkSecurityManager();
    }

    public static Object invoke(Object obj, String method) throws Throwable {
        return ReflectionUtil.invoke(obj, method, new Object[]{null});
    }

    public static Object invoke(Object obj, String method, Object nonNull) throws Throwable {
        return ReflectionUtil.invoke(obj, method, new Object[]{nonNull});
    }

    public static Object invoke(Object obj, String method, Class cls, Object arg) throws Throwable {
        return ReflectionUtil.invoke(obj, method, new Class[]{cls}, new Object[]{arg});
    }

    public static Object invoke(Object obj, String method, Object[] nonNulls, ClassLoader loader) throws Throwable {
        Class[] classes = ReflectionUtil.getClasses(nonNulls);
        if (classes == null) {
            nonNulls = null;
        }
        return ReflectionUtil.invoke(obj, method, classes, nonNulls, loader);
    }

    public static Object invoke(Object obj, String method, Object[] nonNulls) throws Throwable {
        Class[] classes = ReflectionUtil.getClasses(nonNulls);
        if (classes == null) {
            nonNulls = null;
        }
        return ReflectionUtil.invoke(obj, method, classes, nonNulls);
    }

    public static Object invoke(Object obj, String methodName, Class[] argTypes, Object[] nonNulls) throws Throwable {
        return ReflectionUtil.invoke(obj, methodName, argTypes, nonNulls, null);
    }

    public static Object invoke(Object obj, String methodName, Class[] argTypes, Object[] nonNulls, ClassLoader loader) throws Throwable {
        ReflectionUtil.checkStackDepth();
        if (obj == null) {
            throw new Exception("Object cant be null;");
        }
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = original;
        }
        try {
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> cls = obj.getClass();
            Method method = cls.getMethod(methodName, argTypes);
            Object object = method.invoke(obj, nonNulls);
            return object;
        }
        catch (InvocationTargetException it) {
            throw it.getCause();
        }
        catch (Throwable t) {
            throw new Exception("Invocation failed:", t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public static Object invokeStatic(String clsStr, String method, Object[] nonNulls) throws Throwable {
        Class[] classes = ReflectionUtil.getClasses(nonNulls);
        if (classes == null) {
            nonNulls = null;
        }
        return ReflectionUtil.invokeStatic(clsStr, method, classes, nonNulls);
    }

    public static Object invokeStatic(String clsStr, String method, Object[] nonNulls, ClassLoader loader) throws Throwable {
        Class[] classes = ReflectionUtil.getClasses(nonNulls);
        if (classes == null) {
            nonNulls = null;
        }
        return ReflectionUtil.invokeStatic(clsStr, method, classes, nonNulls, loader);
    }

    public static Class[] getClasses(Object[] objs) throws Exception {
        ReflectionUtil.checkStackDepth();
        if (objs == null) {
            return null;
        }
        Class[] classes = new Class[objs.length];
        int i = 0;
        for (Object obj : objs) {
            if (obj == null) {
                if (objs.length == 1) {
                    classes = null;
                } else {
                    classes[i] = Object.class;
                }
            } else {
                classes[i] = obj.getClass();
            }
            ++i;
        }
        return classes;
    }

    public static Object invokeStatic(String clsStr, String methodName, Class[] argTypes, Object[] nonNulls) throws Throwable {
        return ReflectionUtil.invokeStatic(clsStr, methodName, argTypes, nonNulls, null);
    }

    public static Object invokeStatic(String clsStr, String methodName, Class[] argTypes, Object[] nonNulls, ClassLoader loader) throws Throwable {
        Class<?> cls;
        Method method;
        ReflectionUtil.checkStackDepth();
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = original;
        }
        if (!Modifier.isStatic((method = (cls = loader != null ? loader.loadClass(clsStr) : Class.forName(clsStr)).getMethod(methodName, argTypes)).getModifiers())) {
            throw new Exception("Not a static method ..." + methodName + " of " + clsStr);
        }
        try {
            Thread.currentThread().setContextClassLoader(loader);
            Object object = method.invoke(null, nonNulls);
            return object;
        }
        catch (InvocationTargetException it) {
            throw it.getCause();
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public static Object instantiate(String clsStr) throws Throwable {
        return ReflectionUtil.instantiate(clsStr, (ClassLoader)null);
    }

    public static Object instantiate(String clsStr, Object[] nonNulls) throws Throwable {
        Class[] classes = ReflectionUtil.getClasses(nonNulls);
        if (classes == null) {
            nonNulls = null;
        }
        return ReflectionUtil.instantiate(clsStr, classes, nonNulls);
    }

    public static Object instantiate(String clsStr, Class[] classes, Object[] values) throws Throwable {
        return ReflectionUtil.instantiate(clsStr, classes, values, null);
    }

    public static Object instantiate(String clsStr, Class[] classes, Object[] values, ClassLoader loader) throws Throwable {
        ReflectionUtil.checkStackDepth();
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = original;
        }
        Class<?> cls = loader.loadClass(clsStr);
        Constructor<?> con = cls.getConstructor(classes);
        try {
            Thread.currentThread().setContextClassLoader(loader);
            Object obj = con.newInstance(values);
            return obj;
        }
        catch (InvocationTargetException it) {
            throw it.getCause();
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public static Object instantiate(String clsStr, ClassLoader loader) throws Throwable {
        ReflectionUtil.checkStackDepth();
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = original;
        }
        Class<?> cls = loader.loadClass(clsStr);
        Constructor<?> con = cls.getConstructor(new Class[0]);
        try {
            Thread.currentThread().setContextClassLoader(loader);
            Object obj = con.newInstance(new Object[0]);
            return obj;
        }
        catch (InvocationTargetException it) {
            throw it.getCause();
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public static AccessControlException alert(AccessControlException ac, String policyId) {
        if (error_method != null) {
            ReflectionUtil.log("Policy " + policyId + " violated." + ac.getMessage(), ac);
        }
        return ac;
    }

    public static Throwable alertThrowable(Throwable ac, String policyId) throws Throwable {
        if (ac instanceof AccessControlException && error_method != null) {
            ReflectionUtil.log("Policy " + policyId + " violated." + ac.getMessage(), ac);
        }
        return ac;
    }

    public static void log(String message, Throwable t) {
        try {
            if (error_method != null) {
                error_method.invoke(NonCatalogLogger, message, t);
            } else {
                System.out.println(message);
                t.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void logRedAlert(String message, Throwable t) {
        try {
            if (error_method != null) {
                error_method.invoke(NonCatalogLogger_red_alert, message, t);
            } else {
                System.out.println(message);
                t.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            Class<?> non = Class.forName("weblogic.logging.NonCatalogLogger");
            NonCatalogLogger = non.getConstructor(String.class).newInstance("JCSSecurity");
            NonCatalogLogger_red_alert = non.getConstructor(String.class).newInstance("JCSSecurityRedAlert");
            error_method = non.getMethod("error", String.class, Throwable.class);
        }
        catch (ClassNotFoundException cl) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

