/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.config.imp;

import java.util.ArrayList;
import java.util.List;
import oracle.cloud.scanning.api.config.IArchiveConfiguration;
import oracle.cloud.scanning.api.config.MissingResourceResult;
import oracle.cloud.scanning.api.config.Util;
import oracle.cloud.scanning.config.imp.FileConfigurationImpl;
import oracle.cloud.scanning.types.ArchiveDescription;
import oracle.cloud.scanning.types.Configuration;
import oracle.cloud.scanning.types.FileSetIncludeMustDescription;
import oracle.cloud.scanning.types.Filesetsdefinition;

public class ArchiveConfigurationImpl
implements IArchiveConfiguration {
    private ArchiveDescription archive = null;
    private Configuration conf = null;
    private String parent = null;

    public ArchiveConfigurationImpl(ArchiveDescription archive, Configuration conf, String parent) {
        this.archive = archive;
        this.conf = conf;
        this.parent = parent;
    }

    @Override
    public List<MissingResourceResult> checkMissingResourcePaths(List<String> availableResourcePaths) {
        ArrayList<MissingResourceResult> list = new ArrayList<MissingResourceResult>();
        block0: for (Filesetsdefinition.Fileset fs : this.conf.getFilesetsdefinition().getFileset()) {
            for (FileSetIncludeMustDescription fsi : this.archive.getIncludeMust()) {
                boolean exist;
                if (!fs.getName().equals(fsi.getValue())) continue;
                if (fs.getExtensions() != null) {
                    for (String x : fs.getExtensions().getExtension()) {
                        exist = false;
                        for (String path : availableResourcePaths) {
                            if (!path.endsWith("." + x)) continue;
                            exist = true;
                            break;
                        }
                        if (exist) continue;
                        list.add(Util.resourceWithExtensionNotFound(x, this.parent, fsi.getMessageId(), fsi.getSeverity()));
                    }
                }
                if (fs.getPaths() == null) continue block0;
                for (String rx : fs.getPaths().getPath()) {
                    exist = false;
                    for (String path : availableResourcePaths) {
                        if (!FileConfigurationImpl.matchesPath(rx, path)) continue;
                        exist = true;
                        break;
                    }
                    if (exist) continue;
                    list.add(Util.resourceNotFound(Util.reTranslateRxPathToPath(rx), this.parent, fsi.getMessageId(), fsi.getSeverity()));
                }
                continue block0;
            }
        }
        return list;
    }
}

