/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.config.generator;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import oracle.cloud.common.introspection.api.FailedReference;
import oracle.cloud.common.introspection.model.Type;
import oracle.cloud.scanning.api.config.IArchiveConfiguration;
import oracle.cloud.scanning.api.config.IClassConfiguration;
import oracle.cloud.scanning.api.config.IPropertyFileConfiguration;
import oracle.cloud.scanning.api.config.IXMLFileConfiguration;
import oracle.cloud.scanning.api.config.Result;
import oracle.cloud.scanning.api.config.Util;
import oracle.cloud.scanning.config.IAllConfiguration;
import oracle.cloud.scanning.config.imp.ConfigurationImpl;
import oracle.cloud.scanning.types.Severity;

public class IncrementalScansetAdapter
implements IAllConfiguration {
    IAllConfiguration config = null;
    private final Map<String, Pattern> usedAdditionalPackages = new HashMap<String, Pattern>();
    private boolean calculateUsages = false;

    public IncrementalScansetAdapter(IAllConfiguration config) {
        this.config = config;
    }

    public Map<String, Pattern> getUsagesRxPatternMap() {
        return this.usedAdditionalPackages;
    }

    public Set<String> getUsagesRx() {
        return this.usedAdditionalPackages.keySet();
    }

    public Collection<Pattern> getUsagesRxPattern() {
        return this.usedAdditionalPackages.values();
    }

    public IncrementalScansetAdapter(IAllConfiguration config, boolean calculateUsages) {
        this.config = config;
        this.calculateUsages = calculateUsages;
    }

    private Result checkClassToScan(String clazz) {
        Result res = this.config.checkClassToBeScanned(clazz);
        if (res.isAllowed()) {
            for (Pattern p : this.usedAdditionalPackages.values()) {
                if (!p.matcher(clazz).matches()) continue;
                return Util.classNotToBeScanned(clazz, Severity.ERROR);
            }
            return res;
        }
        return res;
    }

    @Override
    public Result checkClassToBeScanned(String clazz) {
        return this.checkClassToScan(clazz);
    }

    @Override
    public List<FailedReference> scanClassFile(InputStream in) throws IOException {
        return this.config.scanClassFile(in);
    }

    @Override
    public List<FailedReference> scanClass(Class cls) throws IOException {
        return this.config.scanClass(cls);
    }

    @Override
    public Type parseClass(Class cls) throws IOException {
        return this.config.parseClass(cls);
    }

    @Override
    public Type parseClassFile(InputStream in) throws IOException {
        return this.config.parseClassFile(in);
    }

    @Override
    public List<FailedReference> scanType(Type modelType) {
        return this.config.scanType(modelType, this);
    }

    @Override
    public Result checkClassAllowed(String clazz) {
        int lastDot;
        if (clazz == null) {
            throw new RuntimeException("clazz can not be null");
        }
        int index = (clazz = clazz.replaceAll("/", "\\.")).indexOf("[");
        if (index > 0) {
            clazz = clazz.substring(0, index);
        }
        if (this.calculateUsages && (lastDot = clazz.lastIndexOf(".")) > 0) {
            String pkg = clazz.substring(0, lastDot);
            this.addExcludedAdditionalPackage(Util.translateToRxClass(pkg + ".**"));
        }
        return this.config.checkClassAllowed(clazz);
    }

    @Override
    public Result checkFieldAllowed(String clazz, String field) {
        return this.config.checkFieldAllowed(clazz, field);
    }

    @Override
    public Result checkMethodAllowed(String clazz, String method, List<String> arguments) {
        return this.config.checkMethodAllowed(clazz, method, arguments);
    }

    @Override
    public Result checkFilePath(String resourcePath) {
        return this.config.checkFilePath(resourcePath);
    }

    @Override
    public IXMLFileConfiguration checkXMLFileConfiguration(String resourcePath) {
        return this.config.checkXMLFileConfiguration(resourcePath);
    }

    private void addExcludedAdditionalPackage(String rx) {
        if (!this.usedAdditionalPackages.containsKey(rx)) {
            Pattern p = ConfigurationImpl.getPattern(rx);
            this.usedAdditionalPackages.put(rx, p);
        }
    }

    public void addExludedAdditionalPackages(Map<String, Pattern> excludedRx) {
        this.usedAdditionalPackages.putAll(excludedRx);
    }

    @Override
    public List<FailedReference> scanType(Type modelType, IClassConfiguration classConfig) {
        return this.config.scanType(modelType, classConfig);
    }

    @Override
    public String getVersion() {
        return this.config.getVersion();
    }

    @Override
    public IArchiveConfiguration checkArchiveConfiguration(String resourcePath) {
        return this.config.checkArchiveConfiguration(resourcePath);
    }

    @Override
    public IPropertyFileConfiguration checkPropertyFileConfiguration(String resourcePath) {
        return this.config.checkPropertyFileConfiguration(resourcePath);
    }
}

