/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.api.config;

import java.util.ArrayList;
import java.util.List;
import oracle.cloud.scanning.ScanningUtil;
import oracle.cloud.scanning.api.config.ClassReferenceResult;
import oracle.cloud.scanning.api.config.ClassToBeScannedResult;
import oracle.cloud.scanning.api.config.ConstructorInvocationResult;
import oracle.cloud.scanning.api.config.FieldUsageResult;
import oracle.cloud.scanning.api.config.MethodInvocationResult;
import oracle.cloud.scanning.api.config.MissingPropertyResult;
import oracle.cloud.scanning.api.config.MissingResourceResult;
import oracle.cloud.scanning.api.config.MissingXMLNodeResult;
import oracle.cloud.scanning.api.config.Result;
import oracle.cloud.scanning.api.config.XMLElementResult;
import oracle.cloud.scanning.config.imp.FileConfigurationImpl;
import oracle.cloud.scanning.types.IncludesAndExcludes;
import oracle.cloud.scanning.types.Severity;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;

public class Util {
    public static String translateToRxClass(String ex) {
        return FileConfigurationImpl.translateToRxClass(ex, null);
    }

    public static List<String> reTranslateRxPathToPath(List<String> ex) {
        ArrayList<String> list = new ArrayList<String>();
        if (ex != null) {
            for (String x : ex) {
                list.add(Util.reTranslateRxPathToPath(x));
            }
        }
        return list;
    }

    public static List<String> reTranslateRxPathToClass(List<String> ex) {
        ArrayList<String> list = new ArrayList<String>();
        if (ex != null) {
            for (String x : ex) {
                list.add(Util.reTranslateRxClassToClass(x));
            }
        }
        return list;
    }

    public static String reTranslateRxPathToPath(String ex) {
        ex = ex.replaceAll("\\.\\*", "**");
        ex = ex.replaceAll("\\[\\^\\/\\]\\*", "*");
        ex = ex.replaceAll("\\\\.", ".");
        return ex;
    }

    public static String reTranslateRxClassToClass(String ex) {
        ex = ex.replaceAll("\\.\\*", "**");
        ex = ex.replaceAll("\\[\\^\\.\\]\\*", "*");
        ex = ex.replaceAll("\\\\.", ".");
        return ex;
    }

    private static Result failed(String message, Severity sev) {
        return Util.failed("", message, sev);
    }

    private static Result failed(String confgiMessage, String message, Severity sev) {
        if (confgiMessage == null) {
            confgiMessage = "";
        } else {
            message = message + "\n";
        }
        Result r = new Result(false, message + confgiMessage, sev == null ? Severity.ERROR : sev);
        return r;
    }

    private static FieldUsageResult failedField(String clazz, String field, String confgiMessage, String message, Severity sev) {
        FieldUsageResult r = new FieldUsageResult(clazz, field, false, confgiMessage, message, sev == null ? Severity.ERROR : sev);
        return r;
    }

    private static MethodInvocationResult failedMethod(String clazz, String method, String confgiMessage, String message, Severity sev) {
        MethodInvocationResult r = new MethodInvocationResult(clazz, method, false, confgiMessage, message, sev == null ? Severity.ERROR : sev);
        return r;
    }

    private static ConstructorInvocationResult failedConstructor(String clazz, String confgiMessage, String message, Severity sev) {
        ConstructorInvocationResult r = new ConstructorInvocationResult(clazz, false, confgiMessage, message, sev == null ? Severity.ERROR : sev);
        return r;
    }

    public static boolean isWarning(Severity sev) {
        return sev == Severity.WARNING;
    }

    public static boolean isError(Severity sev) {
        return sev == Severity.ERROR || sev == null;
    }

    public static boolean isHint(Severity sev) {
        return sev == Severity.HINT;
    }

    public static Result unableToParseFile(String cause) {
        return Util.failed(NLSUtil.localizeMessage("NLS_UNABLE_TO_PARSE_FILE", cause), Severity.ERROR);
    }

    public static ClassReferenceResult classNotAllowed(String messageid, String clsName, Severity sev, Severity onExemption) {
        String tip;
        String string = tip = messageid != null ? NLSUtil.localizeMessageOrReturnId(messageid) : "";
        return new ClassReferenceResult(false, tip, Util.isWarning(sev) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_CLASS_WARN", clsName) : (Util.isError(sev) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_CLASS", clsName) : ""), sev, clsName, onExemption);
    }

    public static Result classNotToBeScanned(String clsName, Severity sev) {
        return Util.failed(NLSUtil.localizeMessage("NLS_NOT_SCANNED_CLASS", clsName), sev);
    }

    public static ClassToBeScannedResult classNotToBeScanned(String clsName, List<String> excludeDependency, Severity sev) {
        ClassToBeScannedResult result = new ClassToBeScannedResult(false, NLSUtil.localizeMessage("NLS_NOT_SCANNED_CLASS", clsName), excludeDependency, sev);
        return result;
    }

    public static Result methodOrConstructorNotAllowed(String messageid, String clsName, Severity sev) {
        String tip;
        String string = tip = messageid != null ? NLSUtil.localizeMessageOrReturnId(messageid) : "";
        return Util.failed(tip, Util.isWarning(sev) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_CONSTRCUTOR_OR_METHOD_WARN", clsName) : (Util.isError(sev) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_CONSTRCUTOR_OR_METHOD", clsName) : ""), sev);
    }

    public static Result instantiationNotAllowed(String messageid, String clsName, Severity sev) {
        String tip;
        String string = tip = messageid != null ? NLSUtil.localizeMessageOrReturnId(messageid) : "";
        return Util.failed(tip, Util.isWarning(sev) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_INSTANTIATION_WARN", clsName) : (Util.isError(sev) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_INSTANTIATION", clsName) : ""), sev);
    }

    public static Result instantiationNotAllowedThruNoArg(String messageid, String clsName, Severity sev) {
        String tip;
        String string = tip = messageid != null ? NLSUtil.localizeMessageOrReturnId(messageid) : "";
        return Util.failed(tip, Util.isWarning(sev) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_INSTANTIATION_NO_ARG_WARN", clsName) : (Util.isError(sev) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_INSTANTIATION_NO_ARG", clsName) : ""), sev);
    }

    public static Result keyNotAllowed(String messageid, Severity sev, String key) {
        String tip;
        String string = tip = messageid != null ? NLSUtil.localizeMessageOrReturnId(messageid) : "";
        return Util.failed(tip, Util.isWarning(sev) ? NLSUtil.localizeMessage("NLS_PROP_NOT_ALLOWED_KEY_WARN", key) : (Util.isError(sev) ? NLSUtil.localizeMessage("NLS_PROP_NOT_ALLOWED_KEY", key) : ""), sev);
    }

    public static Result valueNotAllowed(String messageid, Severity sev, String key, String val) {
        String tip;
        String string = tip = messageid != null ? NLSUtil.localizeMessageOrReturnId(messageid) : "";
        return Util.failed(tip, Util.isWarning(sev) ? NLSUtil.localizeMessage("NLS_PROP_NOT_ALLOWED_VALUE_WARN", key, val) : (Util.isError(sev) ? NLSUtil.localizeMessage("NLS_PROP_NOT_ALLOWED_VALUE", key, val) : ""), sev);
    }

    public static MissingPropertyResult keyMissing(String key, String messageid, Severity sev) {
        String tip;
        String string = tip = messageid != null ? NLSUtil.localizeMessageOrReturnId(messageid) : "";
        return new MissingPropertyResult(tip, Util.isWarning(sev) ? NLSUtil.localizeMessage("NLS_PROP_MISSING_KEY_WARN", key) : (Util.isError(sev) ? NLSUtil.localizeMessage("NLS_PROP_MISSING_KEY", key) : ""), sev, key);
    }

    public static Result extensionNotAllowed(String messageid, String ext, Severity sev) {
        String tip;
        String string = tip = messageid != null ? NLSUtil.localizeMessageOrReturnId(messageid) : "";
        return Util.failed(tip, Util.isWarning(sev) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_FILE_EXTENSION_WARN", new Object[]{ext}) : (Util.isError(sev) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_FILE_EXTENSION", new Object[]{ext}) : ""), sev);
    }

    public static Result pathNotAllowed(String messageid, String ext, Severity sev) {
        String tip;
        String string = tip = messageid != null ? NLSUtil.localizeMessageOrReturnId(messageid) : "";
        return Util.failed(tip, Util.isWarning(sev) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_FILE_PATH_WARN", new Object[]{ext}) : (Util.isError(sev) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_FILE_PATH", new Object[]{ext}) : ""), sev);
    }

    public static Result fieldNotAllowed(String messageid, String cls, String field, Severity sev) {
        String tip;
        String string = tip = messageid != null ? NLSUtil.localizeMessageOrReturnId(messageid) : "";
        return Util.failedField(cls, field, tip, Util.isWarning(sev) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_FIELD_WARN", new Object[]{field, cls}) : (Util.isError(sev) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_FIELD", new Object[]{field, cls}) : ""), sev);
    }

    public static MethodInvocationResult methodNotAllowed(String messageid, String cls, String method, Severity sev) {
        String tip;
        String string = tip = messageid != null ? NLSUtil.localizeMessageOrReturnId(messageid) : "";
        return Util.failedMethod(cls, method, tip, Util.isWarning(sev) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_METHOD_WARN", new Object[]{method, cls}) : (Util.isError(sev) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_METHOD", new Object[]{method, cls}) : ""), sev);
    }

    public static Result constructorNotAllowed(String messageid, String cls, String args, Severity sev) {
        String tip;
        String string = tip = messageid != null ? NLSUtil.localizeMessageOrReturnId(messageid) : "";
        return Util.failedConstructor(cls, tip, Util.isWarning(sev) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_CONSTRCUTOR_WARN", new Object[]{args, cls}) : (Util.isError(sev) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_CONSTRCUTOR", new Object[]{args, cls}) : ""), sev);
    }

    public static Result elementNotAllowed(String qnamePath, IncludesAndExcludes iAndE) {
        String tip;
        String string = tip = iAndE.getMessageId() != null ? NLSUtil.localizeMessageOrReturnId(iAndE.getMessageId()) : "";
        return Util.failed(tip, Util.isWarning(iAndE.getSeverity()) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_ELEMENT_WARN", new Object[]{qnamePath}) + ScanningUtil.getHintForPath(iAndE) : (Util.isError(iAndE.getSeverity()) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_ELEMENT", new Object[]{qnamePath}) + ScanningUtil.getHintForPath(iAndE) : ScanningUtil.getHintForPath(iAndE)), iAndE.getSeverity());
    }

    public static Result elementValueNotAllowed(String val, String qnamePath, IncludesAndExcludes iAndE) {
        String tip = iAndE.getMessageId() != null ? NLSUtil.localizeMessageOrReturnId(iAndE.getMessageId()) : "";
        String warn = NLSUtil.localizeMessage("NLS_NOT_ALLOWED_ELEMENT_VALUE_WARN", new Object[]{val, qnamePath});
        return Util.failed(tip, Util.isWarning(iAndE.getSeverity()) ? warn + ScanningUtil.getHintForPath(iAndE) : (Util.isError(iAndE.getSeverity()) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_ELEMENT_VALUE", new Object[]{val, qnamePath}) + ScanningUtil.getHintForPath(iAndE) : warn + ScanningUtil.getHintForPath(iAndE)), iAndE.getSeverity());
    }

    public static Result attributeValueNotAllowed(String val, String attr, String qnamePath, IncludesAndExcludes iAndE) {
        String tip;
        String string = tip = iAndE.getMessageId() != null ? NLSUtil.localizeMessageOrReturnId(iAndE.getMessageId()) : "";
        return Util.failed(tip, Util.isWarning(iAndE.getSeverity()) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_ATTRIBUTE_VALUE_WARN", new Object[]{val, attr, qnamePath}) + ScanningUtil.getHintForPath(iAndE) : (Util.isError(iAndE.getSeverity()) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_ATTRIBUTE_VALUE", new Object[]{val, attr, qnamePath}) + ScanningUtil.getHintForPath(iAndE) : ScanningUtil.getHintForPath(iAndE)), iAndE.getSeverity());
    }

    public static Result attributeNotAllowed(String attr, String qnamePath, IncludesAndExcludes iAndE) {
        String tip;
        String string = tip = iAndE.getMessageId() != null ? NLSUtil.localizeMessageOrReturnId(iAndE.getMessageId()) : "";
        return Util.failed(tip, Util.isWarning(iAndE.getSeverity()) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_ATTRIBUTE_WARN", new Object[]{attr, qnamePath}) + ScanningUtil.getHintForPath(iAndE) : (Util.isError(iAndE.getSeverity()) ? NLSUtil.localizeMessage("NLS_NOT_ALLOWED_ATTRIBUTE", new Object[]{attr, qnamePath}) + ScanningUtil.getHintForPath(iAndE) : ScanningUtil.getHintForPath(iAndE)), iAndE.getSeverity());
    }

    public static MissingXMLNodeResult failed(IncludesAndExcludes iAndE, String message, MissingXMLNodeResult.NodeType type, String name) {
        String tip = iAndE.getMessageId() != null ? NLSUtil.localizeMessageOrReturnId(iAndE.getMessageId()) : "";
        return new MissingXMLNodeResult(tip, message, iAndE.getSeverity(), type, name);
    }

    public static MissingXMLNodeResult elementNotFound(String must, String qnamePath, IncludesAndExcludes iAndE) {
        return Util.failed(iAndE, Util.isWarning(iAndE.getSeverity()) ? NLSUtil.localizeMessage("NLS_MISSING_ELEMENT_WARN", new Object[]{must, qnamePath}) : (Util.isError(iAndE.getSeverity()) ? NLSUtil.localizeMessage("NLS_MISSING_ELEMENT", new Object[]{must, qnamePath}) : ""), MissingXMLNodeResult.NodeType.ELEMENT, must);
    }

    public static MissingResourceResult resourceWithExtensionNotFound(String must, String parent, String messageid, Severity severity) {
        String tip;
        String string = tip = messageid != null ? NLSUtil.localizeMessageOrReturnId(messageid) : "";
        return new MissingResourceResult(tip, Util.isWarning(severity) ? NLSUtil.localizeMessage("NLS_MISSING_RESOURCE_WITH_EXTENSION_WARN", new Object[]{must, parent}) : (Util.isError(severity) ? NLSUtil.localizeMessage("NLS_MISSING_RESOURCE_WITH_EXTENSION", new Object[]{must, parent}) : ""), severity, must);
    }

    public static MissingResourceResult resourceNotFound(String must, String parent, String messageid, Severity severity) {
        String tip;
        String string = tip = messageid != null ? NLSUtil.localizeMessageOrReturnId(messageid) : "";
        return new MissingResourceResult(tip, Util.isWarning(severity) ? NLSUtil.localizeMessage("NLS_MISSING_RESOURCE_WARN", new Object[]{must, parent}) : (Util.isError(severity) ? NLSUtil.localizeMessage("NLS_MISSING_RESOURCE", new Object[]{must, parent}) : ""), severity, must);
    }

    public static MissingXMLNodeResult attributeNotFound(String must, String qnamePath, IncludesAndExcludes iAndE) {
        return Util.failed(iAndE, Util.isWarning(iAndE.getSeverity()) ? NLSUtil.localizeMessage("NLS_MISSING_ATTRIBUTE_WARN", new Object[]{must, qnamePath}) : (Util.isError(iAndE.getSeverity()) ? NLSUtil.localizeMessage("NLS_MISSING_ATTRIBUTE", new Object[]{must, qnamePath}) : ""), MissingXMLNodeResult.NodeType.ELEMENT, must);
    }

    public static XMLElementResult failed(IncludesAndExcludes iAndE, String message) {
        boolean error = iAndE.getSeverity() == null || iAndE.getSeverity() == Severity.ERROR;
        String tip = iAndE.getMessageId() != null ? NLSUtil.localizeMessageOrReturnId(iAndE.getMessageId()) : "";
        XMLElementResult r = new XMLElementResult(false, !error, tip, message, iAndE.getSeverity());
        return r;
    }
}

