/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cloud.common.introspection.api.FailedReference;
import oracle.cloud.scanning.api.ClassArtifact;
import oracle.cloud.scanning.api.Failure;
import oracle.cloud.scanning.api.config.Result;
import oracle.cloud.scanning.api.config.ResultTypeIdentifier;
import oracle.cloudlogic.javaservice.common.clibase.display.Grid;
import oracle.cloudlogic.javaservice.common.clibase.display.Row;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class Artifact {
    private String path;
    private final List<Artifact> children = new ArrayList<Artifact>();
    protected final List<Failure> failures = new ArrayList<Failure>();
    protected final List<Failure> warnings = new ArrayList<Failure>();
    protected final List<Failure> info = new ArrayList<Failure>();

    Artifact(String path) {
        this.path = path;
    }

    public void updateSummaryReport(Map<Result.ResultSeverity, Map<String, List<ResultTypeIdentifier>>> ret) {
        for (Artifact a : this.children) {
            a.updateSummaryReport(ret);
        }
        this.updateSummaryReport(ret, this.failures);
        this.updateSummaryReport(ret, this.warnings);
        this.updateSummaryReport(ret, this.info);
    }

    private void updateSummaryReport(Map<Result.ResultSeverity, Map<String, List<ResultTypeIdentifier>>> ret, List<Failure> list) {
        for (Failure f : list) {
            List<ResultTypeIdentifier> listexisting;
            Map<String, List<ResultTypeIdentifier>> existing;
            FailedReference ref;
            ResultTypeIdentifier id = null;
            if (f instanceof FailedReference && ResultTypeIdentifier.class.isAssignableFrom((ref = (FailedReference)f).getResult().getClass())) {
                id = (ResultTypeIdentifier)((Object)ref.getResult());
            }
            if (id == null) {
                id = ResultTypeIdentifier.OTHER;
            }
            if ((existing = ret.get((Object)f.getSeverity())) == null) {
                existing = new HashMap<String, List<ResultTypeIdentifier>>();
                ret.put(f.getSeverity(), existing);
            }
            if ((listexisting = existing.get(id.getResultId())) == null) {
                listexisting = new ArrayList<ResultTypeIdentifier>();
                existing.put(id.getResultId(), listexisting);
            }
            listexisting.add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printToLogger(Logger logger, Result.ResultSeverity sev) {
        long count = 0L;
        List<Failure> findings = null;
        switch (sev) {
            case ERROR: {
                count = this.getFailureCount();
                findings = this.failures;
                break;
            }
            case WARNING: {
                count = this.getWarningCount();
                findings = this.warnings;
                break;
            }
            case HINT: {
                count = this.getInfoCount();
                findings = this.info;
            }
        }
        if (count > 0L) {
            switch (sev) {
                case ERROR: {
                    logger.printlnError("Path:" + this.path + " (" + count + (count == 1L ? " Error" : " Errors") + ")");
                    break;
                }
                case WARNING: {
                    logger.printlnWarning("Path:" + this.path + " (" + count + (count == 1L ? " Warning" : " Warnings") + ")");
                    break;
                }
                case HINT: {
                    logger.printlnHint("Path:" + this.path + " (" + count + (count == 1L ? " Hint" : " Hints") + ")");
                }
            }
            Logger logger2 = logger;
            synchronized (logger2) {
                logger.tab();
                if (this.children.isEmpty()) {
                    int c = 1;
                    for (Failure f : findings) {
                        switch (sev) {
                            case ERROR: {
                                logger.printlnError(c + ":" + f.getContextualMessage());
                                break;
                            }
                            case WARNING: {
                                logger.printlnWarning(c + ":" + f.getContextualMessage());
                                break;
                            }
                            case HINT: {
                                logger.printlnHint(c + ":" + f.getContextualMessage());
                            }
                        }
                        ++c;
                    }
                } else {
                    for (Artifact a : this.children) {
                        switch (sev) {
                            case ERROR: {
                                a.printToLogger(logger, Result.ResultSeverity.ERROR);
                                break;
                            }
                            case WARNING: {
                                a.printToLogger(logger, Result.ResultSeverity.WARNING);
                                break;
                            }
                            case HINT: {
                                a.printToLogger(logger, Result.ResultSeverity.HINT);
                            }
                        }
                    }
                }
                logger.shiftTab();
            }
        }
    }

    protected Map<String, Pattern> hasMoreToExcempt(Map<String, Pattern> incrementalUsedSet) {
        HashMap<String, Pattern> map = new HashMap<String, Pattern>();
        ArrayList<Artifact> list = new ArrayList<Artifact>();
        for (Artifact a : this.children) {
            Map<String, Pattern> set = a.hasMoreToExcempt(incrementalUsedSet);
            if (set == null || set.isEmpty()) continue;
            map.putAll(set);
            if (!ClassArtifact.class.isAssignableFrom(a.getClass()) || !((ClassArtifact)a).isRuntimeExempted()) continue;
            list.add(a);
        }
        this.children.removeAll(list);
        return map;
    }

    public long getFailureCount() {
        if (this.children.isEmpty()) {
            return this.failures.size();
        }
        long count = 0L;
        for (Artifact a : this.children) {
            count += a.getFailureCount();
        }
        return count;
    }

    public long getInfoCount() {
        if (this.children.isEmpty()) {
            return this.info.size();
        }
        long count = 0L;
        for (Artifact a : this.children) {
            count += a.getInfoCount();
        }
        return count;
    }

    public long getWarningCount() {
        if (this.children.isEmpty()) {
            return this.warnings.size();
        }
        long count = 0L;
        for (Artifact a : this.children) {
            count += a.getWarningCount();
        }
        return count;
    }

    public Object getAsGridOrString(Result.ResultSeverity sev) {
        List<Failure> findings = null;
        switch (sev) {
            case ERROR: {
                findings = this.failures;
                break;
            }
            case WARNING: {
                findings = this.warnings;
                break;
            }
            case HINT: {
                findings = this.info;
            }
        }
        if (this.children.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>();
            for (Failure a : findings) {
                list.add(a.getContextualMessage());
            }
            return list;
        }
        Grid grid = new Grid();
        grid.addColumn("Resource Entry");
        switch (sev) {
            case ERROR: {
                grid.addColumn("Validation Error(s) - " + this.getFailureCount());
                break;
            }
            case WARNING: {
                grid.addColumn("Warning(s) - " + this.getWarningCount());
                break;
            }
            case HINT: {
                grid.addColumn("Hint(s) - " + this.getInfoCount());
            }
        }
        for (Artifact child : this.children) {
            Object obj;
            Row r;
            if (Result.ResultSeverity.ERROR == sev && child.getFailureCount() != 0L) {
                r = grid.createNewRow();
                r.setValueAt(child.getPath() + "(" + child.getFailureCount() + ")", 0);
                obj = child.getAsGridOrString(Result.ResultSeverity.ERROR);
                r.setObjectAt(obj, 1);
            }
            if (Result.ResultSeverity.WARNING == sev && child.getWarningCount() != 0L) {
                r = grid.createNewRow();
                r.setValueAt(child.getPath() + "(" + child.getWarningCount() + ")", 0);
                obj = child.getAsGridOrString(Result.ResultSeverity.WARNING);
                r.setObjectAt(obj, 1);
            }
            if (Result.ResultSeverity.HINT != sev || child.getInfoCount() == 0L) continue;
            r = grid.createNewRow();
            r.setValueAt(child.getPath() + "(" + child.getInfoCount() + ")", 0);
            obj = child.getAsGridOrString(Result.ResultSeverity.HINT);
            r.setObjectAt(obj, 1);
        }
        return grid;
    }

    public String getPath() {
        return this.path;
    }

    public List<Artifact> getChildren() {
        return this.children;
    }

    public List<Failure> getFailures() {
        return this.failures;
    }

    public List<Failure> getWarnings() {
        return this.warnings;
    }

    public List<Failure> getHints() {
        return this.info;
    }
}

