/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.common.introspection.value;

import java.lang.reflect.Array;
import oracle.cloud.common.introspection.value.SimpleValued;

public class PrimitiveValued
implements SimpleValued {
    private Object obj;
    private String name;

    public PrimitiveValued(String name, Object obj) {
        this.obj = obj;
        this.name = name;
    }

    public boolean isArray() {
        return this.obj.getClass().isArray();
    }

    public Object getValue() {
        return this.obj;
    }

    public Object[] getValueAsArray() {
        if (!this.isArray()) {
            return new Object[]{this.obj};
        }
        Object[] ret = new Object[Array.getLength(this.obj)];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Array.get(this.obj, i);
        }
        return ret;
    }

    @Override
    public String getValueDeclaration() {
        StringBuffer buffer = new StringBuffer();
        if (String.class.isAssignableFrom(this.obj.getClass())) {
            buffer.append("\"" + this.obj.toString() + "\"");
        } else if (this.isArray()) {
            Object[] vals = this.getValueAsArray();
            buffer.append("{\n");
            for (Object v : vals) {
                buffer.append(new PrimitiveValued("", v).getValueDeclaration());
            }
            buffer.append("\n}");
        } else {
            buffer.append(this.obj.toString());
        }
        return buffer.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }
}

