/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.common.introspection.usage.impl;

import java.util.ArrayList;
import java.util.List;
import oracle.cloud.common.introspection.model.ClassDesciption;
import oracle.cloud.common.introspection.usage.impl.AbstractUsageImpl;

public class MethodUsageImpl
extends AbstractUsageImpl {
    private String name;
    private ClassDesciption owner;
    private final List<ClassDesciption> arguments = new ArrayList<ClassDesciption>();
    private int opCode;

    public MethodUsageImpl(int l) {
        super(l);
    }

    public List<String> getArgumentClasses() {
        ArrayList<String> list = new ArrayList<String>();
        for (ClassDesciption d : this.arguments) {
            list.add(d.getFullyQualifiedClassName());
        }
        return list;
    }

    public boolean isConstructor() {
        return "<init>".equals(this.name);
    }

    @Override
    public String getAsString() {
        StringBuffer args = new StringBuffer("");
        boolean first = true;
        for (ClassDesciption desc : this.arguments) {
            if (!first) {
                args.append(", ");
            }
            args.append(desc.getFullyQualifiedClassName());
            first = false;
        }
        if (this.isConstructor()) {
            return "Constructor:" + this.owner.getFullyQualifiedClassName() + "(" + args.toString() + ")";
        }
        return "Method Name:" + this.owner.getFullyQualifiedClassName() + "->" + this.name + "(" + args.toString() + ")";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setOwner(ClassDesciption owner) {
        this.owner = owner;
    }

    public ClassDesciption getOwner() {
        return this.owner;
    }

    public List<ClassDesciption> getArguments() {
        return this.arguments;
    }

    public void setOpCode(int opCode) {
        this.opCode = opCode;
    }

    public int getOpCode() {
        return this.opCode;
    }
}

