/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.common.introspection.model.sig;

import java.util.ArrayList;
import java.util.List;
import oracle.cloud.common.introspection.ASMUtil;
import oracle.cloud.common.introspection.model.ClassDesciption;
import oracle.cloud.common.introspection.model.sig.Bound;
import oracle.cloudlogic.javaservice.common.clibase.util.OrderedMap;

public class ClassSignature {
    private int arrayDimension = 0;
    private String nameAsInClassFile;
    private ClassDesciption classDescription;
    private ClassSignature base;
    private final List<ClassSignature> interfaces = new ArrayList<ClassSignature>();
    private final OrderedMap<String, Bound> parameters = new OrderedMap();
    private final List<ClassSignature> typeVariables = new ArrayList<ClassSignature>();

    public boolean isObject() {
        return this.classDescription.isObject();
    }

    public void incrementDimension() {
        ++this.arrayDimension;
    }

    public String getDeclaration() {
        boolean first;
        StringBuffer buffer = new StringBuffer("");
        if (!this.parameters.isEmpty()) {
            buffer.append(ASMUtil.asDeclaration(this.parameters));
        } else if (!this.typeVariables.isEmpty()) {
            buffer.append("<");
            first = true;
            for (ClassSignature var : this.typeVariables) {
                if (!first) {
                    buffer.append(" , ");
                }
                first = false;
                buffer.append(var.classDescription.getFullyQualifiedClassName() + var.getDeclaration());
            }
            buffer.append(">");
        }
        if (this.base != null && !this.base.isObject()) {
            buffer.append(" extends " + this.base.classDescription.getFullyQualifiedClassName() + this.base.getDeclaration());
        }
        if (!this.interfaces.isEmpty()) {
            buffer.append(" implements ");
            first = true;
            for (ClassSignature in : this.interfaces) {
                if (!first) {
                    buffer.append(" , ");
                }
                first = false;
                buffer.append(in.classDescription.getFullyQualifiedClassName() + in.getDeclaration());
            }
        }
        for (int i = 0; i < this.arrayDimension; ++i) {
            buffer.append("[]");
        }
        return buffer.toString();
    }

    public void setClassBound(String formalParam, ClassSignature sig) {
        Bound b = new Bound();
        b.setClassBound(sig);
        b.setFormalParameter(formalParam);
        this.parameters.put(formalParam, b);
    }

    public void addInterfaceBound(String formalParam, ClassSignature sig) {
        Bound b = this.parameters.get(formalParam);
        if (b == null) {
            b = new Bound();
        }
        b.setFormalParameter(formalParam);
        b.getInterfacesBound().add(sig);
        this.parameters.put(formalParam, b);
    }

    public void setNameAsInClassFile(String className) {
        this.nameAsInClassFile = className;
        this.classDescription = new ClassDesciption(className);
    }

    public void setBase(ClassSignature base) {
        this.base = base;
    }

    public ClassSignature getBase() {
        return this.base;
    }

    public List<ClassSignature> getInterfaces() {
        return this.interfaces;
    }

    public OrderedMap<String, Bound> getParameters() {
        return this.parameters;
    }

    public List<ClassSignature> getTypeVariables() {
        return this.typeVariables;
    }

    public ClassDesciption getClassDescription() {
        return this.classDescription;
    }
}

