/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.common.introspection.model;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.cloud.common.introspection.Accessible;
import oracle.cloud.common.introspection.Annotatable;
import oracle.cloud.common.introspection.access.Access;
import oracle.cloud.common.introspection.access.FieldAccess;
import oracle.cloud.common.introspection.api.ref.Usage;
import oracle.cloud.common.introspection.model.Annotation;
import oracle.cloud.common.introspection.model.Type;
import oracle.cloud.common.introspection.model.sig.field.FieldSignature;

public class Field
implements Annotatable,
Accessible {
    Type parent;
    private String name;
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    private FieldAccess access;
    private FieldSignature signature;
    private Object value;

    public Field(Type type) {
        this.parent = type;
    }

    public String getValueAsString() {
        return this.getValueAsString(this.value);
    }

    public String getValueAsString(Object val) {
        if (val == null) {
            return "null";
        }
        if (val.getClass().isArray()) {
            StringBuffer buffer = new StringBuffer("{");
            for (int i = 0; i < Array.getLength(val); ++i) {
                if (i != 0) {
                    buffer.append(" , ");
                }
                buffer.append(this.getValueAsString(Array.get(val, i)));
            }
            buffer.append("}");
            return buffer.toString();
        }
        if (val.getClass().isPrimitive()) {
            return val.toString();
        }
        if (String.class.isAssignableFrom(val.getClass())) {
            return "\"" + val.toString() + "\"";
        }
        return val.toString();
    }

    @Override
    public Annotatable.TARGET getTarget() {
        return Annotatable.TARGET.FIELD;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public Access getAccess() {
        return this.access;
    }

    public void setSignature(FieldSignature signature) {
        this.signature = signature;
    }

    public FieldSignature getSignature() {
        return this.signature;
    }

    public void setAccess(FieldAccess access) {
        this.access = access;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public List<? extends Usage> getUsages() {
        return Collections.emptyList();
    }
}

