/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.common.introspection.model;

public class ClassDesciption {
    private ClassDesciption outerClass;
    private String fullyQualifiedClassName;
    private String className;

    public ClassDesciption(String classNameAsInClassFile) {
        int indexDoller = classNameAsInClassFile.lastIndexOf("$");
        if (indexDoller >= 0) {
            this.outerClass = new ClassDesciption(classNameAsInClassFile.substring(0, indexDoller));
            this.className = classNameAsInClassFile.substring(indexDoller + 1, classNameAsInClassFile.length());
        } else {
            this.className = classNameAsInClassFile.replaceAll("/", "\\.");
        }
    }

    public boolean isObject() {
        return Object.class.getName().equals(this.fullyQualifiedClassName);
    }

    public void setOuterClass(ClassDesciption outerClass) {
        this.outerClass = outerClass;
    }

    public ClassDesciption getOuterClass() {
        return this.outerClass;
    }

    public String getFullyQualifiedClassName() {
        return this.outerClass == null ? this.className : this.outerClass.getFullyQualifiedClassName() + "." + this.className;
    }

    public String getClassName() {
        return this.className;
    }
}

