/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.common.introspection.asm.visitor;

import oracle.cloud.common.introspection.asm.visitor.ClassSignatureVisitorImpl;
import oracle.cloud.common.introspection.asm.visitor.FieldSignatureVisitor;
import oracle.cloud.common.introspection.model.Argument;
import oracle.cloud.common.introspection.model.Method;
import oracle.cloud.common.introspection.model.sig.ClassSignature;
import oracle.cloud.common.introspection.model.sig.field.FieldSignatureWrapper;
import org.objectweb.asm.signature.SignatureVisitor;

public class MethodSignatureVisitor
implements SignatureVisitor {
    Method method;
    private String formalParam;

    public MethodSignatureVisitor(Method m) {
        this.method = m;
    }

    @Override
    public void visitFormalTypeParameter(String formalParam) {
        this.formalParam = formalParam;
    }

    @Override
    public SignatureVisitor visitClassBound() {
        ClassSignature s = new ClassSignature();
        ClassSignatureVisitorImpl v = new ClassSignatureVisitorImpl(s);
        this.method.setClassBound(this.formalParam, s);
        return v;
    }

    @Override
    public SignatureVisitor visitInterfaceBound() {
        ClassSignature s = new ClassSignature();
        ClassSignatureVisitorImpl v = new ClassSignatureVisitorImpl(s);
        this.method.addInterfaceBound(this.formalParam, s);
        return v;
    }

    @Override
    public SignatureVisitor visitSuperclass() {
        throw new RuntimeException("Visiting super class:" + this);
    }

    @Override
    public SignatureVisitor visitInterface() {
        throw new RuntimeException("visiting interfaces:" + this);
    }

    @Override
    public SignatureVisitor visitParameterType() {
        Argument p = new Argument(this.method);
        FieldSignatureWrapper wrapper = new FieldSignatureWrapper();
        FieldSignatureVisitor vi = new FieldSignatureVisitor(wrapper);
        p.setSignatureWrapper(wrapper);
        this.method.getArguments().add(p);
        return vi;
    }

    @Override
    public SignatureVisitor visitReturnType() {
        this.method.setReturnType(new Argument(this.method));
        FieldSignatureWrapper wrapper = new FieldSignatureWrapper();
        FieldSignatureVisitor vi = new FieldSignatureVisitor(wrapper);
        this.method.getReturnType().setSignatureWrapper(wrapper);
        return vi;
    }

    @Override
    public SignatureVisitor visitExceptionType() {
        FieldSignatureWrapper wrapper = new FieldSignatureWrapper();
        FieldSignatureVisitor vi = new FieldSignatureVisitor(wrapper);
        this.method.getExceptionClassNames().add(wrapper);
        return vi;
    }

    @Override
    public void visitBaseType(char c) {
        throw new RuntimeException("Un-expected invocation");
    }

    @Override
    public void visitTypeVariable(String name) {
        throw new RuntimeException("type variable:" + name);
    }

    @Override
    public SignatureVisitor visitArrayType() {
        throw new RuntimeException("visit Array Type");
    }

    @Override
    public void visitClassType(String name) {
        throw new RuntimeException("visitng class " + name + " :" + this);
    }

    @Override
    public void visitInnerClassType(String string) {
        throw new RuntimeException("Visiting inner class type:" + string);
    }

    @Override
    public void visitTypeArgument() {
        throw new RuntimeException("Visiting type argument:");
    }

    @Override
    public SignatureVisitor visitTypeArgument(char tag) {
        throw new RuntimeException("Visiting type argument:" + tag);
    }

    @Override
    public void visitEnd() {
    }

    public Method getMethod() {
        return this.method;
    }
}

