/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.common.introspection.access;

import oracle.cloud.common.introspection.access.Access;

public class TypeAccess
extends Access {
    public TypeAccess(int access) {
        super(access);
    }

    @Override
    public String getSignature() {
        return this.getAccessSpecifer() + (this.isAbstract() ? " abstract " : "") + (this.isStatic() ? "static " : "") + (this.isFinal() ? " final " : "") + " " + this.getSaulatation();
    }

    public boolean isAbstract() {
        return (this.access & 0x400) != 0;
    }

    public String getSaulatation() {
        if (this.isInterface()) {
            return "interface";
        }
        if (this.isEnum()) {
            return "enum";
        }
        return "class";
    }

    public boolean isInterface() {
        return (this.access & 0x200) != 0;
    }

    public boolean isEnum() {
        return (this.access & 0x4000) != 0;
    }

    public boolean isAnnotation() {
        return (this.access & 0x2000) != 0;
    }

    public boolean isInterfaceOrClass() {
        return this.isInterface() || this.isConcreteClass();
    }

    public boolean isConcreteClass() {
        return !this.isAbstract() && !this.isInterface() && !this.isAnnotation() && !this.isEnum();
    }
}

