/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.common.introspection;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cloud.common.introspection.asm.visitor.FieldSignatureVisitor;
import oracle.cloud.common.introspection.model.Argument;
import oracle.cloud.common.introspection.model.Method;
import oracle.cloud.common.introspection.model.sig.Bound;
import oracle.cloud.common.introspection.model.sig.ClassSignature;
import oracle.cloud.common.introspection.model.sig.field.ArrayType;
import oracle.cloud.common.introspection.model.sig.field.DirectType;
import oracle.cloud.common.introspection.model.sig.field.FieldSignature;
import oracle.cloud.common.introspection.model.sig.field.FieldSignatureWrapper;
import oracle.cloudlogic.javaservice.common.clibase.util.OrderedMap;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;

public class ASMUtil {
    public static List<String> recurseFindFilesWithPatternAt(File dir, String pattern) {
        ArrayList<String> list = new ArrayList<String>();
        ASMUtil.recurseFindAndAddFilesWithPatternAt(dir, "", pattern, list);
        return list;
    }

    public static void recurseFindAndAddFilesWithPatternAt(File dir, String offset, String pattern, List<String> list) {
        String[] dirs;
        File effectiveDir = new File(dir, offset);
        String[] files = ASMUtil.findFilesWithPatternAt(effectiveDir, pattern);
        if (files != null) {
            for (String file : files) {
                list.add(offset + file);
            }
        }
        if ((dirs = ASMUtil.findDirectoriesWithPatternAt(effectiveDir, null)) != null) {
            for (String sub : dirs) {
                ASMUtil.recurseFindAndAddFilesWithPatternAt(dir, offset + sub + File.separator, pattern, list);
            }
        }
    }

    public static String[] findDirectoriesWithPatternAt(File dir, final String pattern) {
        if (dir == null) {
            return null;
        }
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        return dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (!new File(dir, name).isDirectory()) {
                    return false;
                }
                if (pattern == null) {
                    return true;
                }
                Pattern pat = Pattern.compile(pattern);
                Matcher matcher = pat.matcher(name);
                return matcher.matches();
            }
        });
    }

    public static String[] findFilesWithPatternAt(File dir, final String pattern) {
        if (dir == null) {
            return null;
        }
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        return dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (!new File(dir, name).isFile()) {
                    return false;
                }
                if (pattern == null) {
                    return true;
                }
                Pattern pat = Pattern.compile(pattern);
                Matcher matcher = pat.matcher(name);
                return matcher.matches();
            }
        });
    }

    public static void updateMethod(String desc, Method method, String[] exceptions) {
        Type[] args = Type.getArgumentTypes(desc);
        Type ret = Type.getReturnType(desc);
        if (ret != null) {
            Argument p = new Argument(method);
            FieldSignatureWrapper wrapper = new FieldSignatureWrapper();
            wrapper.setActual(ASMUtil.fromDescToFieldSignature(ret.getDescriptor()));
            p.setSignatureWrapper(wrapper);
            method.setReturnType(p);
        }
        for (Type a : args) {
            Argument p = new Argument(method);
            FieldSignatureWrapper wrapper = new FieldSignatureWrapper();
            wrapper.setActual(ASMUtil.fromDescToFieldSignature(a.getDescriptor()));
            p.setSignatureWrapper(wrapper);
            method.getArguments().add(p);
        }
        if (exceptions != null) {
            for (String e : exceptions) {
                FieldSignatureWrapper wraper = new FieldSignatureWrapper();
                wraper.setClassType(Type.getObjectType(e).getClassName().replace('$', '.'));
                method.getExceptionClassNames().add(wraper);
            }
        }
    }

    public static FieldSignature fromSignatureToFieldSignature(String signature) {
        FieldSignatureWrapper wrapper = new FieldSignatureWrapper();
        SignatureReader reader = new SignatureReader(signature);
        reader.accept(new FieldSignatureVisitor(wrapper));
        return wrapper.getActual();
    }

    public static FieldSignature fromDescToFieldSignature(String desc) {
        Type t = Type.getType(desc);
        if (t.getSort() == 9) {
            FieldSignatureWrapper wrapper = new FieldSignatureWrapper();
            ArrayType array = new ArrayType(wrapper);
            for (int i = 0; i < t.getDimensions() - 1; ++i) {
                FieldSignatureWrapper wrapperTemp = new FieldSignatureWrapper();
                wrapper.setActual(new ArrayType(wrapperTemp));
                wrapper = wrapperTemp;
            }
            wrapper.setActual(new DirectType(t.getElementType().getClassName().replaceAll("\\.", "/")));
            return array;
        }
        return new DirectType(t.getClassName().replaceAll("\\.", "/"));
    }

    public static String asDeclaration(OrderedMap<String, Bound> parameters) {
        StringBuffer buffer = new StringBuffer("");
        if (!parameters.isEmpty()) {
            buffer.append("<");
            boolean first = true;
            for (Bound val : parameters.values()) {
                if (!first) {
                    buffer.append(" , ");
                }
                first = false;
                buffer.append(val.getFormalParameter());
                if (val.isObject()) continue;
                buffer.append(" extends ");
                boolean andRequired = false;
                if (val.getClassBound() != null && !val.getClassBound().isObject()) {
                    buffer.append(val.getClassBound().getClassDescription().getFullyQualifiedClassName());
                    buffer.append(val.getClassBound().getDeclaration());
                    andRequired = true;
                }
                for (ClassSignature inter : val.getInterfacesBound()) {
                    if (andRequired) {
                        buffer.append(" & ");
                    }
                    andRequired = true;
                    buffer.append(inter.getClassDescription().getFullyQualifiedClassName());
                    buffer.append(inter.getDeclaration());
                }
            }
            buffer.append(">");
        }
        return buffer.toString();
    }
}

