/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.visitors;

import com.python.pydev.analysis.scopeanalysis.AbstractScopeAnalyzerVisitor;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.editor.codecompletion.revisited.AbstractASTManager;
import org.python.pydev.editor.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.Tuple3;

public final class ImportChecker {
    private final IPythonNature nature;
    private final String moduleName;
    private final AbstractScopeAnalyzerVisitor visitor;

    public ImportChecker(AbstractScopeAnalyzerVisitor visitor, IPythonNature nature, String moduleName) {
        this.nature = nature;
        this.moduleName = moduleName;
        this.visitor = visitor;
    }

    public ImportInfo visitImportToken(IToken token, boolean reportUndefinedImports, ICompletionCache completionCache) {
        return ImportChecker.visitImportToken(reportUndefinedImports, token, this.moduleName, this.nature, this.visitor, completionCache);
    }

    public static ImportInfo visitImportToken(boolean reportUndefinedImports, IToken token, String moduleName, IPythonNature nature, AbstractScopeAnalyzerVisitor visitor, ICompletionCache completionCache) {
        boolean wasResolved = false;
        Tuple3 modTok = null;
        String checkForToken = "";
        if (token instanceof SourceToken) {
            ICodeCompletionASTManager astManager = nature.getAstManager();
            ICompletionState state = CompletionStateFactory.getEmptyCompletionState((String)token.getRepresentation(), (IPythonNature)nature, (ICompletionCache)completionCache);
            try {
                modTok = astManager.findOnImportedMods(new IToken[]{token}, state, moduleName, visitor.current);
            }
            catch (CompletionRecursionException completionRecursionException) {
                modTok = null;
            }
            if (modTok != null && modTok.o1 != null) {
                checkForToken = (String)modTok.o2;
                if (((String)modTok.o2).length() == 0) {
                    wasResolved = true;
                } else {
                    try {
                        checkForToken = AbstractASTManager.getTokToSearchInOtherModule((Tuple3)modTok);
                        if (astManager.getRepInModule((IModule)modTok.o1, checkForToken, nature) != null) {
                            wasResolved = true;
                        }
                    }
                    catch (CompletionRecursionException completionRecursionException) {}
                }
            }
            if (!wasResolved && reportUndefinedImports) {
                visitor.onAddUnresolvedImport(token);
            }
        }
        if (modTok != null) {
            return new ImportInfo((IModule)modTok.o1, checkForToken, (IToken)modTok.o3, wasResolved);
        }
        return new ImportInfo(null, null, null, wasResolved);
    }

    public static class ImportInfo {
        public final IModule mod;
        public final IToken token;
        public final String rep;
        public final boolean wasResolved;
        private boolean useActualDefinitionCache = false;
        private IDefinition[] definitionCache;

        public ImportInfo(IModule mod, String rep, IToken token, boolean wasResolved) {
            this.mod = mod;
            this.rep = rep;
            this.token = token;
            this.wasResolved = wasResolved;
        }

        public String toString() {
            FastStringBuffer buffer = new FastStringBuffer();
            buffer.append("ImportInfo(");
            buffer.append(" Resolved:");
            buffer.append(this.wasResolved);
            if (this.wasResolved) {
                buffer.append(" Rep:");
                buffer.append(this.rep);
                buffer.append(" Mod:");
                buffer.append(this.mod != null ? this.mod.getName() : "null");
            }
            buffer.append(")");
            return buffer.toString();
        }

        public IDefinition[] getDefinitions(IPythonNature nature, ICompletionCache completionCache) throws Exception {
            if (this.useActualDefinitionCache) {
                return this.definitionCache;
            }
            this.useActualDefinitionCache = true;
            this.definitionCache = this.mod != null ? this.mod.findDefinition(CompletionStateFactory.getEmptyCompletionState((String)this.rep, (IPythonNature)nature, (ICompletionCache)completionCache), -1, -1, nature) : new IDefinition[0];
            return this.definitionCache;
        }

        public Definition getModuleDefinitionFromImportInfo(IPythonNature nature, ICompletionCache completionCache) {
            try {
                IDefinition[] definitions = this.getDefinitions(nature, completionCache);
                int len = definitions.length;
                int i = 0;
                while (i < len) {
                    IDefinition definition = definitions[i];
                    if (definition instanceof Definition) {
                        Definition d = (Definition)definition;
                        if (d.module != null && d.value.length() == 0 && d.ast == null) {
                            return d;
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        }
    }
}

