/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.organizeimports;

import com.python.pydev.analysis.AnalysisPlugin;
import com.python.pydev.analysis.CtxInsensitiveImportComplProposal;
import com.python.pydev.analysis.ctrl_1.UndefinedVariableFixParticipant;
import com.python.pydev.analysis.ui.AutoImportsPreferencesPage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.IOrganizeImports;
import org.python.pydev.editor.codefolding.MarkerAnnotationAndPosition;
import org.python.pydev.editor.codefolding.PySourceViewer;
import org.python.pydev.parser.PyParser;
import org.python.pydev.shared_core.structure.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizeImports
implements IOrganizeImports {
    private static final String DIALOG_SETTINGS = "com.python.pydev.analysis.ORGANIZE_IMPORTS_DIALOG";

    public boolean beforePerformArrangeImports(PySelection ps, PyEdit edit) {
        if (!AutoImportsPreferencesPage.doAutoImportOnOrganizeImports()) {
            return true;
        }
        ArrayList<MarkerAnnotationAndPosition> undefinedVariablesMarkers = this.getUndefinedVariableMarkers(edit);
        TreeMap<Integer, MarkerAnnotationAndPosition> map = new TreeMap<Integer, MarkerAnnotationAndPosition>();
        for (MarkerAnnotationAndPosition marker : undefinedVariablesMarkers) {
            if (marker.position == null) continue;
            int start = marker.position.offset;
            map.put(start, marker);
        }
        UndefinedVariableFixParticipant variableFixParticipant = new UndefinedVariableFixParticipant(false);
        ArrayList<ICompletionProposalExtension2> completionsToApply = new ArrayList<ICompletionProposalExtension2>();
        HashSet<String> treatedVars = new HashSet<String>();
        Boolean[] keepGoing = new Boolean[]{true};
        final IDialogSettings dialogSettings = AnalysisPlugin.getDefault().getDialogSettings();
        for (MarkerAnnotationAndPosition marker : map.values()) {
            if (!keepGoing[0].booleanValue()) break;
            int start = marker.position.offset;
            int end = start + marker.position.length;
            if (start < 0 || end <= start) continue;
            IDocument doc = ps.getDoc();
            ArrayList<ICompletionProposal> props = new ArrayList<ICompletionProposal>();
            try {
                String string = doc.get(start, end - start);
                if (treatedVars.contains(string)) continue;
                variableFixParticipant.addProps(marker, null, null, ps, start, edit.getPythonNature(), edit, props);
                if (props.size() <= 0) continue;
                edit.selectAndReveal(start, end - start);
                treatedVars.add(string);
                Shell activeShell = Display.getCurrent().getActiveShell();
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(activeShell, (ILabelProvider)new LabelProvider(){

                    public Image getImage(Object element) {
                        CtxInsensitiveImportComplProposal comp = (CtxInsensitiveImportComplProposal)((Object)element);
                        return comp.getImage();
                    }

                    public String getText(Object element) {
                        CtxInsensitiveImportComplProposal comp = (CtxInsensitiveImportComplProposal)((Object)element);
                        return comp.getDisplayString();
                    }
                }){

                    protected IDialogSettings getDialogBoundsSettings() {
                        IDialogSettings section = dialogSettings.getSection(OrganizeImports.DIALOG_SETTINGS);
                        if (section == null) {
                            section = dialogSettings.addNewSection(OrganizeImports.DIALOG_SETTINGS);
                        }
                        return section;
                    }

                    protected Point getInitialSize() {
                        IDialogSettings settings = this.getDialogBoundsSettings();
                        if (settings != null) {
                            try {
                                int width = settings.getInt("DIALOG_WIDTH");
                                int height = settings.getInt("DIALOG_HEIGHT");
                                if (width > 0 & height > 0) {
                                    return new Point(width, height);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        return new Point(300, 300);
                    }
                };
                dialog.setTitle("Choose import");
                dialog.setMessage("Which import should be added?");
                dialog.setElements(props.toArray());
                int returnCode = dialog.open();
                if (returnCode == 0) {
                    ICompletionProposalExtension2 firstResult = (ICompletionProposalExtension2)dialog.getFirstResult();
                    completionsToApply.add(firstResult);
                    continue;
                }
                if (returnCode != 1) continue;
                keepGoing[0] = false;
            }
            catch (Exception e) {
                try {
                    Log.log((Throwable)e);
                }
                catch (Exception e2) {
                    Log.log((Throwable)e2);
                }
            }
        }
        for (ICompletionProposalExtension2 comp : completionsToApply) {
            int offset = 0;
            comp.apply((ITextViewer)edit.getPySourceViewer(), ' ', 0, offset);
        }
        return true;
    }

    private ArrayList<MarkerAnnotationAndPosition> getUndefinedVariableMarkers(PyEdit edit) {
        PySourceViewer s = edit.getPySourceViewer();
        ArrayList<MarkerAnnotationAndPosition> undefinedVariablesMarkers = new ArrayList<MarkerAnnotationAndPosition>();
        Iterator it = s.getMarkerIterator();
        while (it.hasNext()) {
            MarkerAnnotationAndPosition m = (MarkerAnnotationAndPosition)it.next();
            IMarker marker = m.markerAnnotation.getMarker();
            try {
                Integer attribute;
                String type = marker.getType();
                if (type == null || !type.equals("com.python.pydev.analysis.pydev_analysis_problemmarker") || (attribute = Integer.valueOf(marker.getAttribute("PYDEV_TYPE", -1))) == null || !attribute.equals(3)) continue;
                undefinedVariablesMarkers.add(m);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        return undefinedVariablesMarkers;
    }

    public void afterPerformArrangeImports(PySelection ps, PyEdit pyEdit) {
        PyParser parser;
        if (!AutoImportsPreferencesPage.doAutoImportOnOrganizeImports()) {
            return;
        }
        if (pyEdit != null && (parser = pyEdit.getParser()) != null) {
            parser.forceReparse(new Object[]{new Tuple((Object)"AnalysisParserObserver:force", (Object)true)});
        }
    }
}

