/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.ctrl_1;

import com.python.pydev.analysis.IAnalysisPreferences;
import com.python.pydev.analysis.ctrl_1.IAnalysisMarkersParticipant;
import com.python.pydev.analysis.ctrl_1.IgnoreCompletionProposal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyFormatStd;
import org.python.pydev.editor.codefolding.MarkerAnnotationAndPosition;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_ui.ImageCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoreErrorParticipant
implements IAnalysisMarkersParticipant {
    private Image annotationImage;
    private Set<Integer> handled = new HashSet<Integer>();
    private PyFormatStd.FormatStd format;

    public IgnoreErrorParticipant() {
        this(null);
    }

    IgnoreErrorParticipant(PyFormatStd.FormatStd format) {
        ImageCache analysisImageCache = PydevPlugin.getImageCache();
        this.annotationImage = analysisImageCache.get("icons/annotation_obj.gif");
        this.format = format;
    }

    @Override
    public void addProps(MarkerAnnotationAndPosition marker, IAnalysisPreferences analysisPreferences, final String line, final PySelection ps, int offset, IPythonNature nature, final PyEdit edit, List<ICompletionProposal> props) throws BadLocationException, CoreException {
        Integer id = (Integer)marker.markerAnnotation.getMarker().getAttribute("PYDEV_TYPE");
        if (this.handled.contains(id)) {
            return;
        }
        this.handled.add(id);
        final String messageToIgnore = analysisPreferences.getRequiredMessageToIgnore(id);
        if (line.indexOf(messageToIgnore) != -1) {
            return;
        }
        IgnoreCompletionProposal proposal = new IgnoreCompletionProposal(messageToIgnore, ps.getEndLineOffset(), 0, offset, this.annotationImage, messageToIgnore.substring(1), null, null, 10, edit){

            public void apply(IDocument document) {
                FastStringBuffer strToAdd = new FastStringBuffer(messageToIgnore, 5);
                int lineLen = line.length();
                int endLineIndex = ps.getEndLineOffset();
                boolean isComment = ParsingUtils.isCommentPartition((IDocument)document, (int)endLineIndex);
                int whitespacesAtEnd = 0;
                char c = '\u0000';
                int i = lineLen - 1;
                while (i >= 0) {
                    c = line.charAt(i);
                    if (c != ' ') break;
                    ++whitespacesAtEnd;
                    --i;
                }
                if (isComment) {
                    if (whitespacesAtEnd == 0) {
                        strToAdd.insert(0, ' ');
                    }
                } else {
                    PyFormatStd.FormatStd formatStd = IgnoreErrorParticipant.this.format;
                    if (formatStd == null) {
                        formatStd = edit != null ? edit.getFormatStd() : PyFormatStd.getFormat();
                    }
                    strToAdd.insert(0, '#');
                    PyFormatStd.formatComment((PyFormatStd.FormatStd)formatStd, (FastStringBuffer)strToAdd);
                    if (c != '\r' && c != '\n' && c != '\u0000' && c != ' ') {
                        int spacesBeforeComment = formatStd.spacesBeforeComment;
                        if (spacesBeforeComment < 0) {
                            spacesBeforeComment = 1;
                        }
                        if ((spacesBeforeComment -= whitespacesAtEnd) > 0) {
                            strToAdd.insertN(0, ' ', spacesBeforeComment);
                        }
                    }
                }
                this.fReplacementString = strToAdd.toString();
                super.apply(document);
            }
        };
        props.add((ICompletionProposal)proposal);
    }
}

