/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.project.facet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.web.internal.WSTWebPlugin;

public class ProductManager {
    private static final String APPLICATION_CONTENT_FOLDER = "EarContent";
    private static final String WEB_CONTENT_FOLDER = "WebContent";
    private static final String EJB_CONTENT_FOLDER = "ejbModule";
    private static final String APP_CLIENT_CONTENT_FOLDER = "appClientModule";
    private static final String JCA_CONTENT_FOLDER = "connectorModule";
    private static final String DEFAULT_SOURCE_FOLDER = "src";
    private static final String ADD_TO_EAR_BY_DEFAULT = "false";
    private static final String ADD_TO_EAR_RUNTIME_EXCEPTIONS = "";
    private static final String OUTPUT_FOLDER = "build/classes";
    private static final String USE_SINGLE_ROOT_STRUCTURE = "false";
    private static final String VIEWER_SYNC_FOR_WEBSERVICES = "true";
    private static final String ID_PERSPECTIVE_HIERARCHY_VIEW = "org.eclipse.ui.navigator.ProjectExplorer";
    private static final String SHOW_JAVA_EE_MODULE_DEPENDENCY_PAGE = "true";
    private static final String FINAL_PERSPECTIVE = "org.eclipse.jst.j2ee.J2EEPerspective";
    private static final String FINAL_WEB_PERSPECTIVE = "org.eclipse.wst.web.ui.webDevPerspective";
    private static final String DYNAMIC_WEB_GENERATE_DD = "true";
    private static final char RUNTIME_SEPARATOR = ':';
    private static final String[] DEFAULT_RUNTIME_KEYS = new String[]{"defaultRuntime1", "defaultRuntime2", "defaultRuntime3", "defaultRuntime4"};

    public static String getProperty(String key) {
        if (key == null) {
            return null;
        }
        String value = null;
        if (Platform.getProduct() != null) {
            value = Platform.getProduct().getProperty(key);
        }
        if (value == null) {
            value = Platform.getPreferencesService().getString("org.eclipse.wst.web", key, null, null);
        }
        if (value == null) {
            if (key.equals("earContent")) {
                return APPLICATION_CONTENT_FOLDER;
            }
            if (key.equals("webContent")) {
                return WEB_CONTENT_FOLDER;
            }
            if (key.equals("ejbContent")) {
                return EJB_CONTENT_FOLDER;
            }
            if (key.equals("appClientContent")) {
                return APP_CLIENT_CONTENT_FOLDER;
            }
            if (key.equals("jcaContent")) {
                return JCA_CONTENT_FOLDER;
            }
            if (key.equals("defaultSource")) {
                return DEFAULT_SOURCE_FOLDER;
            }
            if (key.equals("addToEarByDefault")) {
                return "false";
            }
            if (key.equals("addToEARruntimeExceptions")) {
                return ADD_TO_EAR_RUNTIME_EXCEPTIONS;
            }
            if (key.equals("useSingleRootStructure")) {
                return "false";
            }
            if (key.equals("viewerSyncForWebservices")) {
                return "true";
            }
            if (key.equals("outputFolder")) {
                return OUTPUT_FOLDER;
            }
            if (key.equals("idPerspectiveHierarchyView")) {
                return ID_PERSPECTIVE_HIERARCHY_VIEW;
            }
            if (key.equals("finalPerspectiveAppClient")) {
                return FINAL_PERSPECTIVE;
            }
            if (key.equals("finalPerspectiveEar")) {
                return FINAL_PERSPECTIVE;
            }
            if (key.equals("finalPerspectiveEjb")) {
                return FINAL_PERSPECTIVE;
            }
            if (key.equals("finalPerspectiveJca")) {
                return FINAL_PERSPECTIVE;
            }
            if (key.equals("finalPerspectiveStaticWeb")) {
                return FINAL_WEB_PERSPECTIVE;
            }
            if (key.equals("finalPerspectiveUtility")) {
                return FINAL_PERSPECTIVE;
            }
            if (key.equals("finalPerspectiveWeb")) {
                return FINAL_PERSPECTIVE;
            }
            if (key.equals("showJavaEEModuleDependencyPage")) {
                return "true";
            }
            if (key.equals("dynamic_web_generate_dd")) {
                return "true";
            }
            if (key.equals("ejb_interface_package_suffix")) {
                return ADD_TO_EAR_RUNTIME_EXCEPTIONS;
            }
        }
        return value;
    }

    public static boolean shouldAddToEARByDefault() {
        String value = ProductManager.getProperty("addToEarByDefault");
        return Boolean.valueOf(value);
    }

    public static boolean shouldUseSingleRootStructure() {
        String value = ProductManager.getProperty("useSingleRootStructure");
        return Boolean.valueOf(value);
    }

    public static boolean shouldUseViewerSyncForWebservices() {
        String value = ProductManager.getProperty("viewerSyncForWebservices");
        return Boolean.valueOf(value);
    }

    public static List getDefaultRuntimes() {
        ArrayList<IRuntime> theRuntimes = null;
        Set runtimes = RuntimeManager.getRuntimes();
        if (!runtimes.isEmpty()) {
            IRuntime defaultRuntime = null;
            int i = 0;
            while (i < DEFAULT_RUNTIME_KEYS.length) {
                defaultRuntime = ProductManager.getMatchingRuntime(DEFAULT_RUNTIME_KEYS[i], runtimes);
                if (defaultRuntime != null) {
                    if (theRuntimes == null) {
                        theRuntimes = new ArrayList<IRuntime>(DEFAULT_RUNTIME_KEYS.length);
                    }
                    theRuntimes.add(defaultRuntime);
                }
                ++i;
            }
        }
        if (theRuntimes == null) {
            theRuntimes = Collections.EMPTY_LIST;
        }
        return theRuntimes;
    }

    private static IRuntime getMatchingRuntime(String defaultProductRuntimeProperty, Set runtimes) {
        String defaultProductRuntimeKey = ProductManager.getProperty(defaultProductRuntimeProperty);
        if (defaultProductRuntimeKey == null || defaultProductRuntimeKey.length() == 0) {
            return null;
        }
        int seperatorIndex = defaultProductRuntimeKey.indexOf(58);
        if (seperatorIndex < 0 && seperatorIndex < defaultProductRuntimeKey.length()) {
            WSTWebPlugin.logError("Invalid default product runtime id.  It should follow the format <facet runtime id>:<facet version>.  Id processed: " + defaultProductRuntimeKey);
            return null;
        }
        String defaultRuntimeID = defaultProductRuntimeKey.substring(0, seperatorIndex);
        String defaultFacetVersion = defaultProductRuntimeKey.substring(seperatorIndex + 1);
        for (IRuntime runtime : runtimes) {
            List runtimeComps = runtime.getRuntimeComponents();
            if (runtimeComps.isEmpty()) continue;
            for (IRuntimeComponent runtimeComp : runtimeComps) {
                if (!defaultRuntimeID.equals(runtimeComp.getRuntimeComponentType().getId()) || !defaultFacetVersion.equals(runtimeComp.getRuntimeComponentVersion().getVersionString())) continue;
                return runtime;
            }
        }
        return null;
    }
}

