/*
 * Decompiled with CFR 0.152.
 */
package oracle.nuviaq.config;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import oracle.cloud.paas.internal.Helper;

public class NuviaqProperties {
    private static Properties properties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Properties get() {
        if (properties != null) return properties;
        Class<NuviaqProperties> clazz = NuviaqProperties.class;
        synchronized (NuviaqProperties.class) {
            properties = new Properties();
            String domainDir = System.getProperty("nuviaq.domain.config");
            if (domainDir == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            File nuviaqDomainConfigDir = new File(domainDir);
            FileInputStream in = null;
            try {
                in = new FileInputStream(new File(nuviaqDomainConfigDir, "nuviaq.properties"));
                properties.load(in);
                File nuvaiqConfigFile = new File(properties.getProperty("nuviaq.config.dir"), "nuviaq.properties");
                properties.load(new FileInputStream(nuvaiqConfigFile));
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    Helper.safeClose(in);
                    throw throwable;
                }
            }
            Helper.safeClose(in);
            // ** MonitorExit[var0] (shouldn't be in output)
            return properties;
        }
    }

    public static String getProperty(String key) {
        Properties props = NuviaqProperties.get();
        if (props == null) {
            return null;
        }
        return props.getProperty(key);
    }
}

