/*
 * Decompiled with CFR 0.152.
 */
package oracle.nuviaq.common;

public class UrlUtil {
    public static String mapUrl(String uri) {
        if (uri.startsWith("/service/system")) {
            return "/paas-admin/v13.2" + uri.substring("/service/system".length());
        }
        if (uri.startsWith("/service/job")) {
            return "/paas-job/v13.2" + uri.substring("/service/job".length());
        }
        if (uri.startsWith("/system")) {
            return "/paas-admin/v13.2" + uri.substring("/system".length());
        }
        if (uri.startsWith("/service")) {
            return "/paas/java/v13.2" + uri.substring("/service".length()).replaceFirst("/group", "").replaceFirst("/instance", "");
        }
        if (uri.startsWith("/domain")) {
            return "/paas/java/v13.2" + uri.replaceFirst("/domain", "").replaceFirst("/service", "");
        }
        if (uri.startsWith("/job")) {
            return "/paas-job/v13.2" + uri.substring("/job".length());
        }
        return uri;
    }

    public static String getRelativePath(String path1, String path2) {
        while (path1.endsWith("/")) {
            path1 = path1.substring(0, path1.length() - 1);
        }
        while (path2.endsWith("/")) {
            path2 = path1.substring(0, path2.length() - 1);
        }
        if (path1.equals(path2)) {
            return "";
        }
        path1 = path1 + "/";
        int oldPos1 = 1;
        int oldPos2 = 1;
        int pos1 = path1.indexOf(47, 1);
        int pos2 = path2.indexOf(47, 1);
        while (pos1 >= 0 && pos2 >= 0 && pos1 == pos2 && path1.substring(0, pos1).equals(path2.substring(0, pos2))) {
            oldPos1 = pos1 + 1;
            oldPos2 = pos2 + 1;
            pos1 = path1.indexOf(47, oldPos1);
            pos2 = path2.indexOf(47, oldPos2);
        }
        String sub2 = path2.substring(oldPos2);
        String prefix = "";
        while ((pos1 = path1.indexOf(47, oldPos1)) > 0) {
            oldPos1 = pos1 + 1;
            prefix = prefix + "../";
        }
        return prefix + sub2;
    }
}

