/*
 * Decompiled with CFR 0.152.
 */
package oracle.nuviaq.common;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import oracle.cloud.paas.exception.ResourcePermissionException;
import oracle.cloud.paas.nls.MessageBundleUtil;
import weblogic.security.Security;

public abstract class AccessController {
    private static final String CSR_ADMINS_GROUP = "CSRAdmins";
    private static final String TENANT_ADMIN_GROUP = "TenantAdminGroup";
    private static final String ADMIN_SUFFIX = "Administrators";
    public static final String JAVA_ADMIN_SUFFIX = "Java_Administrators";
    private static final String SYSTEM_ROLE = "SystemAdministrators";
    private static final String SDI_APPID = "OCLOUD9_SDI_APPID";

    protected abstract String getAuthenticatedUser();

    public final void checkSystemRole() {
        if (!this.hasSystemRole()) {
            throw new ResourcePermissionException(MessageBundleUtil.msg.getString("OC-PAAS-10101"));
        }
    }

    public final void checkSystemOrCsrTenantAdminRole() {
        Set<String> roles = this.getRoles();
        if (!this.hasSystemRole(this.getRoles()) && !this.hasCSRTenantAdminRole(roles)) {
            throw new ResourcePermissionException(MessageBundleUtil.msg.getString("OC-PAAS-10101"));
        }
    }

    public final void checkAdminRole(String tenantId, String instanceName) {
        if (!this.hasAdminRole(tenantId, instanceName)) {
            throw new ResourcePermissionException(MessageBundleUtil.msg.getString("OC-PAAS-10102", instanceName, tenantId));
        }
    }

    public final boolean hasSystemRole() {
        return this.hasSystemRole(this.getRoles());
    }

    protected final boolean hasSystemRole(Set<String> roles) {
        return this.getAuthenticatedUser().equalsIgnoreCase(SDI_APPID) || roles.contains(SYSTEM_ROLE);
    }

    public final boolean hasAdminRole(String tenantId, String serviceName) {
        Set<String> roles = this.getRoles();
        return roles.contains(serviceName + "." + JAVA_ADMIN_SUFFIX) || roles.contains(serviceName + "." + ADMIN_SUFFIX) || this.hasSystemRole(roles) || this.hasCSRTenantAdminRole(roles);
    }

    protected final Set<String> getRoles() {
        Subject subject = Security.getCurrentSubject();
        String authenticatedUser = this.getAuthenticatedUser();
        HashSet<String> roles = new HashSet<String>();
        String principalNames = "";
        for (Principal p : subject.getPrincipals()) {
            if (!authenticatedUser.equals(p.getName())) {
                roles.add(p.getName());
            }
            principalNames = principalNames + p.getName() + " ";
        }
        System.out.println("[Nuviaq debug] authenticatedUser: " + authenticatedUser + ", Principals: " + principalNames);
        return roles;
    }

    protected final boolean hasCSRTenantAdminRole(Set<String> roles) {
        return roles.contains(CSR_ADMINS_GROUP) && roles.contains(TENANT_ADMIN_GROUP);
    }
}

