/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import oracle.cloud.paas.model.Association;
import oracle.cloud.paas.model.Property;
import oracle.cloud.paas.model.ServiceSize;
import oracle.cloud.paas.model.ServiceState;

@XmlRootElement(name="ServiceInstance", namespace="http://xmlns.oracle.com/cloud/paas/1.0")
@XmlType(name="ServiceInstanceType", namespace="http://xmlns.oracle.com/cloud/paas/1.0")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ServiceInstance {
    @XmlElement(name="GroupName")
    private String groupName;
    @XmlElement(name="DomainName")
    private String domainName;
    @XmlElement(name="InstanceName")
    private String instanceName;
    @XmlElement(name="Size")
    private ServiceSize size;
    @XmlElement(name="State")
    private ServiceState state;
    @XmlElementWrapper(name="Properties")
    @XmlElement(name="Property")
    private List<Property> properties = new ArrayList<Property>();
    @XmlElementWrapper(name="Associations")
    @XmlElement(name="Association")
    private List<Association> associations = new ArrayList<Association>();

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
        this.domainName = groupName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
        this.groupName = domainName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public ServiceSize getSize() {
        return this.size;
    }

    public void setSize(ServiceSize size) {
        this.size = size;
    }

    public ServiceState getState() {
        return this.state;
    }

    public void setState(ServiceState state) {
        this.state = state;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        for (Property p : this.getProperties()) {
            if (!p.getName().equals(name)) continue;
            return p.getValue();
        }
        return null;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public List<Association> getAssociations() {
        return this.associations;
    }

    public Association getAssociation(String name) {
        for (Association b : this.getAssociations()) {
            if (!b.getTargetInstanceName().equals(name)) continue;
            return b;
        }
        return null;
    }

    public void setAssociations(List<Association> associations) {
        this.associations = associations;
    }

    public String toStringFull() {
        StringBuffer dp = new StringBuffer("PlatformDeploymentType(");
        dp.append("groupName=");
        dp.append(this.groupName);
        dp.append("; ");
        dp.append("instanceName=");
        dp.append(this.instanceName);
        dp.append("; ");
        dp.append("state=");
        dp.append((Object)this.state);
        dp.append("; ");
        if (!this.properties.isEmpty()) {
            dp.append("\n\tProperties [");
            for (Property property : this.properties) {
                dp.append(property.getName());
                dp.append("=");
                dp.append(property.getValue());
                dp.append("; ");
            }
            dp.deleteCharAt(dp.lastIndexOf(";"));
            dp.append("]");
        }
        if (!this.associations.isEmpty()) {
            dp.append("\n\tBindings [");
            for (Association binding : this.associations) {
                dp.append("Binding <");
                dp.append("name");
                dp.append("=");
                dp.append(binding.getTargetInstanceName());
                if (!binding.getProperties().isEmpty()) {
                    dp.append("\n\t\tProperties [");
                    for (Property property : binding.getProperties()) {
                        dp.append(property.getName());
                        dp.append("=");
                        dp.append(property.getValue());
                        dp.append("; ");
                    }
                    dp.deleteCharAt(dp.lastIndexOf(";"));
                    dp.append("] ");
                }
                dp.append(">; ");
            }
            dp.deleteCharAt(dp.lastIndexOf(";"));
            dp.append("]");
        }
        return dp.toString();
    }
}

