/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="Metric", namespace="http://xmlns.oracle.com/cloud/paas/1.0")
@XmlType(name="MetricType", namespace="http://xmlns.oracle.com/cloud/paas/1.0")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Metric {
    @XmlElement(name="Server")
    private String server;
    @XmlElement(name="Component")
    private String component;
    @XmlElement(name="Name", required=true)
    private String name;
    @XmlElement(name="Value")
    private double value;
    @XmlElement(name="Unit")
    private String unit;
    @XmlElement(name="Category")
    private String category;
    @XmlElement(name="Description")
    private String description;

    public Metric() {
    }

    public Metric(String server, String component, String name, double value) {
        this.server = server;
        this.component = component;
        this.name = name;
        this.value = value;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public void setParentComponent(String parentComponent) {
        if (this.component == null) {
            this.component = parentComponent;
        } else if (parentComponent != null) {
            this.component = parentComponent + "/" + this.component;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isValueMiliSeconds() {
        return "ServletExecutionTimeHigh".equals(this.name) || "ServletExecutionTimeLow".equals(this.name) || "ServletExecutionTimeTotal".equals(this.name);
    }

    public boolean isValueAverage() {
        return "ServletExecutionTimeAverage".equals(this.name);
    }

    public boolean isValueByte() {
        return "JVMHeapFree".equals(this.name) || "JVMHeapMaxSize".equals(this.name) || "JVMHeapSize".equals(this.name);
    }

    public boolean isValueCount() {
        return "WebModuleActiveSessions".equals(this.name) || "WebModuleActiveSessionsHigh".equals(this.name) || "WebModuleTotalOpenedSessions".equals(this.name) || "ServletExecutions".equals(this.name) || "WorkManagerPendingRequests".equals(this.name) || "WorkManagerCompletedRequests".equals(this.name) || "DatasourceActiveConnections".equals(this.name) || "DatasourceConnections".equals(this.name);
    }
}

