/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import oracle.cloud.paas.internal.Helper;
import oracle.cloud.paas.model.LibraryDeployType;
import oracle.cloud.paas.model.LibraryState;
import oracle.cloud.paas.model.LibraryType;

@XmlRootElement(name="Library", namespace="http://xmlns.oracle.com/cloud/paas/1.0")
@XmlType(name="LibraryType", namespace="http://xmlns.oracle.com/cloud/paas/1.0")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Library {
    @XmlElement(name="DomainName", required=true)
    private String domainName;
    @XmlElement(name="InstanceName", required=true)
    private String instanceName;
    @XmlElement(name="Name", required=true)
    private String name;
    @XmlElement(name="SpecVersion")
    private String specVersion;
    @XmlElement(name="ImplVersion")
    private String implVersion;
    @XmlElement(name="State", required=false)
    private LibraryState state;
    @XmlElement(name="Type", required=false)
    private LibraryType type;
    @XmlElement(name="DeployType", required=false)
    private LibraryDeployType deployType;

    public Library() {
    }

    public Library(String domainName, String instanceName, String name, String specVersion, String implVersion, LibraryType type) {
        this.domainName = domainName;
        this.instanceName = instanceName;
        this.name = name;
        this.specVersion = specVersion;
        this.implVersion = implVersion;
        this.type = type;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public void setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
    }

    public String getImplVersion() {
        return this.implVersion;
    }

    public void setImplVersion(String implVersion) {
        this.implVersion = implVersion;
    }

    public LibraryState getState() {
        return this.state;
    }

    public void setState(LibraryState state) {
        this.state = state;
    }

    public LibraryType getType() {
        return this.type;
    }

    public void setType(LibraryType type) {
        this.type = type;
    }

    public LibraryDeployType getDeployType() {
        return this.deployType;
    }

    public void setDeployType(LibraryDeployType deployType) {
        this.deployType = deployType;
    }

    public String createNormalizedFileName() {
        return this.getName().replaceAll("[^A-Za-z0-9]", "_") + "." + this.getType().name().toLowerCase();
    }

    public boolean match(Library anotherLib) {
        return this.name.equals(anotherLib.name) && (this.specVersion != null && this.specVersion.equals(anotherLib.specVersion) || this.specVersion == null && anotherLib.specVersion == null) && (this.implVersion != null && this.implVersion.equals(anotherLib.implVersion) || this.implVersion == null && anotherLib.implVersion == null);
    }

    public String getVersionedName() {
        return Helper.getVersionedLibraryName(this.name, this.specVersion, this.implVersion);
    }

    public String toStringFull() {
        StringBuffer dp = new StringBuffer("LibraryType(");
        dp.append("domainName=");
        dp.append(this.domainName);
        dp.append("; ");
        dp.append("instanceName=");
        dp.append(this.instanceName);
        dp.append("; ");
        dp.append("name=");
        dp.append(this.name);
        if (this.specVersion != null) {
            dp.append("; ");
            dp.append("specVersion=");
            dp.append(this.specVersion);
        }
        if (this.implVersion != null) {
            dp.append("; ");
            dp.append("implVersion=");
            dp.append(this.implVersion);
        }
        if (this.deployType != null) {
            dp.append("; ");
            dp.append("deployType=");
            dp.append(this.deployType.name());
        }
        if (this.type != null) {
            dp.append("; ");
            dp.append("type=");
            dp.append(this.type.name());
        }
        if (this.state != null) {
            dp.append("; ");
            dp.append("state=");
            dp.append(this.state.name());
        }
        dp.append(")");
        return dp.toString();
    }
}

