/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cloud.paas.api.ServiceInstanceLogCriteria;
import oracle.cloud.paas.internal.Helper;

public class ServiceInstanceLogCriteriaImpl
implements ServiceInstanceLogCriteria {
    private static String LOG4J_MODULE = "log4j.javacloud.root";
    private static String QP_BEFORE = "before";
    private static String QP_AFTER = "after";
    private static String QP_CONTAINS = "contains";
    private static String QP_APP = "app";
    private static String QP_QUERY_STRING = "string";
    private static String QP_SEVERITY = "severity";
    private static String QP_MSG_LEVEL = "msgLevel";
    private static String QP_APP_EQUALS = "appEquals";
    private static String QP_MSG_ID_EQUALS = "msgIdEquals";
    private static String QP_SYSTEM = "system";
    private static String QP_MODULE_ID = "moduleId";
    private static String QP_COMP_ID = "compId";
    private static String QP_MSG_ID = "msgId";
    private static String QP_MSG_TXT = "msgTxt";
    private static String QP_SUPPL_DETAIL = "suppleDetail";
    private static String QP_MSG_TYPE = "msgType";
    private static String QP_XML = "xml";
    private static String QP_LAST = "last";
    private static String QP_LIMIT = "limit";
    Map<String, List<String>> internalMap = new HashMap<String, List<String>>();

    @Override
    public ServiceInstanceLogCriteria clear() {
        this.internalMap = new HashMap<String, List<String>>();
        return this;
    }

    public Map<String, List<String>> getMap() {
        return this.internalMap;
    }

    @Override
    public ServiceInstanceLogCriteria contains(String value) {
        this.put(QP_CONTAINS, value);
        return this;
    }

    @Override
    public ServiceInstanceLogCriteria returnXML() {
        this.putUnique(QP_XML, "true");
        return this;
    }

    @Override
    public ServiceInstanceLogCriteria severity(String value) {
        this.put(QP_SEVERITY, value);
        return this;
    }

    @Override
    public ServiceInstanceLogCriteria application(String value) {
        this.put(QP_APP, value);
        return this;
    }

    @Override
    public ServiceInstanceLogCriteria after(Date date) {
        this.putUnique(QP_AFTER, this.convertDate(date));
        return this;
    }

    @Override
    public ServiceInstanceLogCriteria before(Date date) {
        this.putUnique(QP_BEFORE, this.convertDate(date));
        return this;
    }

    public String convertDate(Date date) {
        return Helper.printSILogFormatDate(date);
    }

    public ServiceInstanceLogCriteria criteria(String crit, String val) {
        this.put(crit, val);
        return this;
    }

    private void put(String key, String value) {
        if (!this.getMap().containsKey(key)) {
            this.getMap().put(key, new ArrayList());
        }
        this.getMap().get(key).add(value);
    }

    private void putUnique(String key, String value) {
        this.getMap().put(key, new ArrayList());
        this.getMap().get(key).add(value);
    }

    @Override
    public ServiceInstanceLogCriteria last(int lastCount) {
        String param = "" + lastCount;
        this.putUnique(QP_LAST, param);
        return this;
    }

    @Override
    public ServiceInstanceLogCriteria limit(int limitCount) {
        String param = "" + limitCount;
        this.putUnique(QP_LIMIT, param);
        return this;
    }

    @Override
    public ServiceInstanceLogCriteria log4JOnly() {
        this.putUnique(QP_MODULE_ID, LOG4J_MODULE);
        return this;
    }

    @Override
    public ServiceInstanceLogCriteria application(String appName, boolean exactMatch) {
        if (!exactMatch) {
            return this.application(appName);
        }
        this.put(QP_APP_EQUALS, appName);
        return this;
    }

    @Override
    public ServiceInstanceLogCriteria systemLogs(boolean systemLogs) {
        this.putUnique(QP_SYSTEM, "" + systemLogs);
        return this;
    }

    @Override
    public ServiceInstanceLogCriteria id(String messageId, boolean exactMatch) {
        if (!exactMatch) {
            return this.id(messageId);
        }
        this.put(QP_MSG_ID_EQUALS, messageId);
        return this;
    }

    @Override
    public ServiceInstanceLogCriteria id(String messageId) {
        this.put(QP_MSG_ID, messageId);
        return this;
    }
}

