/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.internal;

import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import oracle.cloud.paas.model.Application;
import oracle.cloud.paas.model.ApplicationType;
import oracle.cloud.paas.model.Applications;
import oracle.cloud.paas.model.Association;
import oracle.cloud.paas.model.DataSource;
import oracle.cloud.paas.model.DataSources;
import oracle.cloud.paas.model.ExceptionWrapper;
import oracle.cloud.paas.model.Files;
import oracle.cloud.paas.model.IdentityDomain;
import oracle.cloud.paas.model.IdentityDomains;
import oracle.cloud.paas.model.Job;
import oracle.cloud.paas.model.JobStatus;
import oracle.cloud.paas.model.Jobs;
import oracle.cloud.paas.model.Libraries;
import oracle.cloud.paas.model.Library;
import oracle.cloud.paas.model.LibraryDeployType;
import oracle.cloud.paas.model.LibraryType;
import oracle.cloud.paas.model.ListWrapper;
import oracle.cloud.paas.model.Log;
import oracle.cloud.paas.model.Logs;
import oracle.cloud.paas.model.PaasFile;
import oracle.cloud.paas.model.Property;
import oracle.cloud.paas.model.Server;
import oracle.cloud.paas.model.Servers;
import oracle.cloud.paas.model.ServiceInstance;
import oracle.cloud.paas.model.ServiceInstances;
import oracle.cloud.paas.model.ServiceSize;
import oracle.cloud.paas.model.ServiceState;
import oracle.cloud.paas.model.ServiceType;
import oracle.cloud.paas.model.java.CredentialInfo;
import oracle.cloud.paas.model.java.KeyStoreEntryInfo;
import oracle.cloud.paas.model.java.KeyStoreEntryInfoList;

public class SchemaGenerator {
    public static void main(String[] args) {
        SchemaGenerator generator;
        String schemaFile = args[0];
        Class[] classes = new Class[]{Applications.class, Application.class, ApplicationType.class, Association.class, DataSource.class, DataSources.class, ExceptionWrapper.class, Files.class, Jobs.class, Job.class, JobStatus.class, Logs.class, Log.class, Libraries.class, Library.class, LibraryDeployType.class, LibraryType.class, ListWrapper.class, ServiceInstances.class, ServiceInstance.class, PaasFile.class, Property.class, Server.class, Servers.class, IdentityDomain.class, IdentityDomains.class, ServiceSize.class, ServiceState.class, ServiceType.class, CredentialInfo.class, KeyStoreEntryInfo.class, KeyStoreEntryInfoList.class};
        JAXBContext jaxbContext = null;
        try {
            jaxbContext = JAXBContext.newInstance((Class[])classes);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        SchemaGenerator schemaGenerator = generator = new SchemaGenerator();
        schemaGenerator.getClass();
        MySchemaOutputResolver sor = schemaGenerator.new MySchemaOutputResolver(schemaFile);
        try {
            jaxbContext.generateSchema((SchemaOutputResolver)sor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class MySchemaOutputResolver
    extends SchemaOutputResolver {
        private String schemaFile;
        private boolean firstCall = true;

        public MySchemaOutputResolver(String schemaFile) {
            this.schemaFile = schemaFile;
        }

        public Result createOutput(String namespaceURI, String suggestedFileName) throws IOException {
            if (!this.firstCall) {
                this.schemaFile = this.schemaFile + "." + suggestedFileName;
            }
            this.firstCall = false;
            File file = new File(this.schemaFile);
            StreamResult result = new StreamResult(file);
            result.setSystemId(file.toURI().toURL().toString());
            return result;
        }
    }
}

