/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.internal;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.lang.reflect.Constructor;
import oracle.cloud.paas.exception.ManagerException;
import oracle.cloud.paas.internal.Helper;
import oracle.cloud.paas.internal.TrustTokenProvider;
import oracle.nuviaq.config.NuviaqProperties;

public class SAMLTokenAuthFilter
extends ClientFilter {
    private static final String AUTH_TYPE_NAME = "oit";
    private static final String TRUST_TOKEN_PROVIDER_CLASS = "oracle.cloud.paas.internal.TrustTokenProviderImpl";
    private static final String AUTH_HEADER = "Authorization";
    private String authHeaderValue;
    private TrustTokenProvider trustTokProvider;

    public SAMLTokenAuthFilter(String user, TrustTokenProvider provider) {
        this.trustTokProvider = provider == null ? this.getDefaultTrustTokProvider() : provider;
        String b64Tok = this.trustTokProvider.generateToken(user);
        String skipOwsm = NuviaqProperties.getProperty("nuviaq.skip.owsm.security.filter");
        this.authHeaderValue = !"true".equals(skipOwsm) ? "oit " + b64Tok : "OIT " + b64Tok;
    }

    private TrustTokenProvider getDefaultTrustTokProvider() {
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(TRUST_TOKEN_PROVIDER_CLASS);
            Constructor<?> constructor = c.getConstructor(new Class[0]);
            return (TrustTokenProvider)TrustTokenProvider.class.cast(constructor.newInstance(new Object[0]));
        }
        catch (Throwable e) {
            throw new ManagerException("Error loading default trust token provider: " + Helper.getCauseInfo(e), e);
        }
    }

    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        if (!request.getHeaders().containsKey((Object)AUTH_HEADER)) {
            request.getHeaders().add((Object)AUTH_HEADER, (Object)this.authHeaderValue);
        }
        return this.getNext().handle(request);
    }
}

