/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.internal;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlEnumValue;
import oracle.cloud.paas.exception.InvalidDescriptorException;
import oracle.cloud.paas.internal.AbstractManagerImpl;
import oracle.cloud.paas.internal.Helper;
import oracle.cloud.paas.internal.JobQueryParameters;
import oracle.cloud.paas.model.Application;
import oracle.cloud.paas.model.ApplicationState;
import oracle.cloud.paas.model.ApplicationType;
import oracle.cloud.paas.model.Library;
import oracle.nuviaq.common.XmlUtil;

public class PublicManagerHelper
implements JobQueryParameters {
    private AbstractManagerImpl mgr;
    private Logger logger;
    private HttpServletRequest request;

    public PublicManagerHelper(AbstractManagerImpl mgr) {
        this.mgr = mgr;
        this.logger = AbstractManagerImpl.logger;
    }

    public PublicManagerHelper(AbstractManagerImpl mgr, HttpServletRequest request) {
        this.mgr = mgr;
        this.logger = AbstractManagerImpl.logger;
        this.request = request;
    }

    public ClientResponse listJobs(Map<String, String> filter) {
        String requestAcceptHeader;
        WebResource resource = this.mgr.createJobResource();
        if (filter != null) {
            String libName;
            String appName;
            String instanceName;
            String groupName = filter.get("domain");
            if (groupName != null) {
                this.mgr.assertPathParameter("groupName", groupName);
            }
            if ((instanceName = filter.get("service")) != null) {
                this.mgr.assertPathParameter("instanceName", instanceName);
            }
            if ((appName = filter.get("application")) != null) {
                this.mgr.assertPathParameter("applicationName", appName);
            }
            if ((libName = filter.get("library")) != null) {
                this.mgr.assertPathParameter("libraryName", libName);
            }
            for (Map.Entry<String, String> entry : filter.entrySet()) {
                resource = resource.queryParam(entry.getKey(), entry.getValue());
            }
        }
        if ((requestAcceptHeader = this.getRequestAcceptHeader()) != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        return (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).get(ClientResponse.class);
    }

    public ClientResponse describeJob(String jobID) {
        this.mgr.assertPathParameter("jobID", jobID);
        WebResource resource = this.mgr.createJobResource(jobID);
        this.logger.fine("describeJob REST URI: " + resource.getURI());
        String requestAcceptHeader = this.getRequestAcceptHeader();
        if (requestAcceptHeader != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        return (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).get(ClientResponse.class);
    }

    public ClientResponse describeJobProperty(String jobID, String property) {
        this.mgr.assertPathParameter("jobID", jobID);
        WebResource resource = this.mgr.createJobPropertyResource(jobID, property);
        this.logger.fine("describeJob REST URI: " + resource.getURI());
        String requestAcceptHeader = this.getRequestAcceptHeader();
        if (requestAcceptHeader != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        return (ClientResponse)resource.accept(new String[]{"text/plain"}).get(ClientResponse.class);
    }

    public ClientResponse listJobLogs(String jobID) {
        this.mgr.assertPathParameter("jobID", jobID);
        WebResource resource = this.mgr.createJobLogResource(jobID);
        this.logger.fine("listJobLogs REST URI: " + resource.getURI());
        String requestAcceptHeader = this.getRequestAcceptHeader();
        if (requestAcceptHeader != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        return (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).get(ClientResponse.class);
    }

    public ClientResponse fetchJobLog(String jobID, String logName) {
        this.mgr.assertPathParameter("jobID", jobID);
        this.mgr.assertPathParameter("logName", logName);
        WebResource resource = this.mgr.createJobLogResource(jobID, logName);
        this.logger.fine("fetchJobLog REST URI: " + resource.getURI());
        return (ClientResponse)((WebResource.Builder)resource.type("application/xml").accept(new String[]{"application/xml", "text/plain"})).get(ClientResponse.class);
    }

    public ClientResponse describeServiceInstance(String groupName, String instanceName) {
        this.mgr.assertPathParameter("groupName", groupName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        WebResource resource = this.mgr.createInstanceResource(groupName, instanceName);
        this.logger.fine("describeServiceInstance REST URI: " + resource.getURI());
        String requestAcceptHeader = this.getRequestAcceptHeader();
        if (requestAcceptHeader != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        return (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).get(ClientResponse.class);
    }

    public ClientResponse listServiceInstances(String groupName) {
        this.mgr.assertPathParameter("groupName", groupName);
        WebResource resource = this.mgr.createInstanceResource(groupName);
        this.logger.fine("listServiceInstances REST URI: " + resource.getURI());
        String requestAcceptHeader = this.getRequestAcceptHeader();
        if (requestAcceptHeader != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        return (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).get(ClientResponse.class);
    }

    public ClientResponse listServers(String groupName, String instanceName) {
        this.mgr.assertPathParameter("groupName", groupName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        WebResource resource = this.mgr.createServerResource(groupName, instanceName);
        this.logger.fine("listServers REST URI: " + resource.getURI());
        String requestAcceptHeader = this.getRequestAcceptHeader();
        if (requestAcceptHeader != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        return (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).get(ClientResponse.class);
    }

    public ClientResponse describeServer(String groupName, String instanceName, String serverName) {
        this.mgr.assertPathParameter("groupName", groupName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        this.mgr.assertPathParameter("serverName", serverName);
        WebResource resource = this.mgr.createServerResource(groupName, instanceName, serverName);
        this.logger.fine("describeServer REST URI: " + resource.getURI());
        String requestAcceptHeader = this.getRequestAcceptHeader();
        if (requestAcceptHeader != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        return (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).get(ClientResponse.class);
    }

    public ClientResponse listDataSources(String groupName, String instanceName) {
        this.mgr.assertPathParameter("groupName", groupName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        WebResource resource = this.mgr.createDatasourceResource(groupName, instanceName);
        this.logger.fine("listDataSources REST URI: " + resource.getURI());
        String requestAcceptHeader = this.getRequestAcceptHeader();
        if (requestAcceptHeader != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        return (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).get(ClientResponse.class);
    }

    public ClientResponse describeDataSource(String groupName, String instanceName, String dataSourceName) {
        this.mgr.assertPathParameter("groupName", groupName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        this.mgr.assertPathParameter("dataSourceName", dataSourceName);
        WebResource resource = this.mgr.createDatasourceResource(groupName, instanceName, dataSourceName);
        this.logger.fine("describeDataSource REST URI: " + resource.getURI());
        String requestAcceptHeader = this.getRequestAcceptHeader();
        if (requestAcceptHeader != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        return (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).get(ClientResponse.class);
    }

    public ClientResponse deployApplication(String groupName, String instanceName, String applicationName, ApplicationType type, InputStream applicationArchive, ApplicationState initialState) {
        if (initialState != ApplicationState.STATE_ACTIVE && initialState != ApplicationState.STATE_ADMIN) {
            throw new IllegalArgumentException("Unsupported starting application state: " + initialState.name());
        }
        this.mgr.assertPathParameter("groupName", groupName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        this.mgr.assertPathParameter("applicationName", applicationName);
        Application appType = new Application();
        appType.setGroupName(groupName);
        appType.setInstanceName(instanceName);
        appType.setApplicationName(applicationName);
        appType.setType(type);
        appType.setState(initialState);
        WebResource resource = this.mgr.createApplicationResource(appType.getGroupName(), appType.getInstanceName());
        this.logger.fine("deployApplication REST URI: " + resource.getURI());
        InputStream appDescriptor = this.marshalApp(appType);
        FormDataMultiPart multiPart = new FormDataMultiPart().field("archive", (Object)applicationArchive, MediaType.APPLICATION_OCTET_STREAM_TYPE).field("descriptor", (Object)appDescriptor, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        return (ClientResponse)((WebResource.Builder)resource.type("multipart/form-data").accept(new String[]{"application/xml", "text/plain"})).post(ClientResponse.class, (Object)multiPart);
    }

    public ClientResponse redeployApplication(String groupName, String instanceName, String applicationName, InputStream applicationArchive, ApplicationState initialState) {
        this.mgr.assertPathParameter("groupName", groupName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        this.mgr.assertPathParameter("applicationName", applicationName);
        Application appType = new Application();
        appType.setGroupName(groupName);
        appType.setInstanceName(instanceName);
        appType.setApplicationName(applicationName);
        appType.setState(initialState);
        WebResource resource = this.mgr.createApplicationResource(appType.getGroupName(), appType.getInstanceName(), appType.getApplicationName());
        this.logger.fine("redeployApplication REST URI: " + resource.getURI());
        InputStream appDescriptor = this.marshalApp(appType);
        FormDataMultiPart multiPart = new FormDataMultiPart().field("archive", (Object)applicationArchive, MediaType.APPLICATION_OCTET_STREAM_TYPE).field("descriptor", (Object)appDescriptor, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        return (ClientResponse)((WebResource.Builder)resource.type("multipart/form-data").accept(new String[]{"application/xml", "text/plain"})).put(ClientResponse.class, (Object)multiPart);
    }

    public ClientResponse undeployApplication(String groupName, String instanceName, String applicationName) {
        this.mgr.assertPathParameter("groupName", groupName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        this.mgr.assertPathParameter("applicationName", applicationName);
        WebResource resource = this.mgr.createApplicationResource(groupName, instanceName, applicationName);
        this.logger.fine("undeployApplication REST URI: " + resource.getURI());
        return (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).delete(ClientResponse.class);
    }

    public ClientResponse describeApplication(String groupName, String instanceName, String applicationName) {
        this.mgr.assertPathParameter("groupName", groupName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        this.mgr.assertPathParameter("applicationName", applicationName);
        WebResource resource = this.mgr.createApplicationResource(groupName, instanceName, applicationName);
        this.logger.fine("describeApplication REST URI: " + resource.getURI());
        String requestAcceptHeader = this.getRequestAcceptHeader();
        if (requestAcceptHeader != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        return (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).get(ClientResponse.class);
    }

    public ClientResponse describeApplicationProperty(String groupName, String instanceName, String applicationName, String property) {
        this.mgr.assertPathParameter("groupName", groupName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        this.mgr.assertPathParameter("applicationName", applicationName);
        WebResource resource = this.mgr.createApplicationPropertyResource(groupName, instanceName, applicationName, property);
        this.logger.fine("describeApplication REST URI: " + resource.getURI());
        String requestAcceptHeader = this.getRequestAcceptHeader();
        if (requestAcceptHeader != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        return (ClientResponse)resource.accept(new String[]{"text/plain"}).get(ClientResponse.class);
    }

    public ClientResponse listApplications(String groupName, String instanceName) {
        this.mgr.assertPathParameter("groupName", groupName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        WebResource resource = this.mgr.createApplicationResource(groupName, instanceName);
        this.logger.fine("listApplications REST URI: " + resource.getURI());
        String requestAcceptHeader = this.getRequestAcceptHeader();
        if (requestAcceptHeader != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        return (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).get(ClientResponse.class);
    }

    public ClientResponse stopApplication(String groupName, String instanceName, String applicationName, ApplicationState targetState) {
        if (targetState != ApplicationState.STATE_PREPARED && targetState != ApplicationState.STATE_ADMIN) {
            throw new IllegalArgumentException("Unsupported stopping application state: " + targetState.name());
        }
        String logMethod = "stopApplication REST URI: ";
        return this.changeApplicationState(groupName, instanceName, applicationName, targetState, "stopApplication REST URI: ");
    }

    private ClientResponse changeApplicationState(String groupName, String instanceName, String applicationName, ApplicationState targetState, String logMethod) {
        this.mgr.assertPathParameter("groupName", groupName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        this.mgr.assertPathParameter("applicationName", applicationName);
        WebResource resource = this.mgr.createApplicationStateChangeResource(groupName, instanceName, applicationName);
        this.logger.fine(logMethod + resource.getURI());
        return (ClientResponse)((WebResource.Builder)resource.type("text/plain").accept(new String[]{"application/xml", "text/plain"})).put(ClientResponse.class, (Object)this.getApplicationStateXmlValue(targetState));
    }

    public ClientResponse startApplication(String groupName, String instanceName, String applicationName, ApplicationState targetState) {
        if (targetState != ApplicationState.STATE_ACTIVE && targetState != ApplicationState.STATE_ADMIN) {
            throw new IllegalArgumentException("Unsupported starting application state: " + targetState.name());
        }
        String logMethod = "startApplication REST URI: ";
        return this.changeApplicationState(groupName, instanceName, applicationName, targetState, logMethod);
    }

    public ClientResponse listServiceInstanceLogs(String groupName, String instanceName) {
        this.mgr.assertPathParameter("groupName", groupName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        WebResource resource = this.mgr.createInstanceLogResource(groupName, instanceName);
        this.logger.fine("listApplicationLogs REST URI: " + resource.getURI());
        return (ClientResponse)((WebResource.Builder)resource.type("text/plain").accept(new String[]{"application/xml", "text/plain"})).get(ClientResponse.class);
    }

    public ClientResponse fetchServiceInstanceLog(String groupName, String instanceName, String logName) {
        this.mgr.assertPathParameter("groupName", groupName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        this.mgr.assertPathParameter("logName", logName, true);
        WebResource resource = this.mgr.createInstanceLogResource(groupName, instanceName, logName);
        this.logger.fine("fetchApplicationLog REST URI: " + resource.getURI());
        return (ClientResponse)((WebResource.Builder)resource.type("application/xml").accept(new String[]{"application/xml", "text/plain"})).get(ClientResponse.class);
    }

    public ClientResponse listWebModuleInstances(String groupName, String instanceName, String applicationName) {
        this.mgr.assertPathParameter("groupName", groupName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        this.mgr.assertPathParameter("applicationName", applicationName);
        WebResource resource = this.mgr.createWebModuleResource(groupName, instanceName, applicationName);
        this.logger.fine("listWebModuleInstances REST URI: " + resource.getURI());
        String requestAcceptHeader = this.getRequestAcceptHeader();
        if (requestAcceptHeader != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        return (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).get(ClientResponse.class);
    }

    public ClientResponse listWebModuleInstances(String groupName, String instanceName, String applicationName, String moduleURI) {
        this.mgr.assertPathParameter("groupName", groupName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        this.mgr.assertPathParameter("applicationName", applicationName);
        WebResource resource = this.mgr.createWebModuleResource(groupName, instanceName, applicationName, moduleURI);
        this.logger.fine("listWebModuleInstances REST URI: " + resource.getURI());
        String requestAcceptHeader = this.getRequestAcceptHeader();
        if (requestAcceptHeader != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        return (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).get(ClientResponse.class);
    }

    public ClientResponse listWorkManagerInstances(String groupName, String instanceName, String applicationName) {
        this.mgr.assertPathParameter("groupName", groupName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        this.mgr.assertPathParameter("applicationName", applicationName);
        WebResource resource = this.mgr.createWorkManagerResource(groupName, instanceName, applicationName);
        this.logger.fine("listWorkManagerInstances REST URI: " + resource.getURI());
        String requestAcceptHeader = this.getRequestAcceptHeader();
        if (requestAcceptHeader != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        return (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).get(ClientResponse.class);
    }

    public ClientResponse listWorkManagerInstances(String groupName, String instanceName, String applicationName, String workManagerName) {
        this.mgr.assertPathParameter("groupName", groupName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        this.mgr.assertPathParameter("applicationName", applicationName);
        WebResource resource = this.mgr.createWorkManagerResource(groupName, instanceName, applicationName, workManagerName);
        this.logger.fine("listWorkManagerInstances REST URI: " + resource.getURI());
        String requestAcceptHeader = this.getRequestAcceptHeader();
        if (requestAcceptHeader != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        return (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).get(ClientResponse.class);
    }

    public ClientResponse queryServiceInstanceMetrics(String groupName, String instanceName, String groupBy, boolean includeMetadata) {
        String requestAcceptHeader;
        this.mgr.assertPathParameter("groupName", groupName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        WebResource resource = this.mgr.createInstanceMetricResource(groupName, instanceName);
        this.logger.fine("queryServiceInstanceMetrics REST URI: " + resource.getURI());
        if (groupBy != null) {
            resource = resource.queryParam("GroupBy", groupBy);
        }
        if (includeMetadata) {
            resource = resource.queryParam("IncludeMetadata", "true");
        }
        if ((requestAcceptHeader = this.getRequestAcceptHeader()) != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        return (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).get(ClientResponse.class);
    }

    public ClientResponse queryServiceInstanceMetrics(String groupName, String instanceName, String metricName, String groupBy, boolean includeMetadata) {
        String requestAcceptHeader;
        this.mgr.assertPathParameter("groupName", groupName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        this.mgr.assertPathParameter("metricName", metricName);
        WebResource resource = this.mgr.createInstanceMetricResource(groupName, instanceName, metricName);
        this.logger.fine("queryServiceInstanceMetrics REST URI: " + resource.getURI());
        if (groupBy != null) {
            resource = resource.queryParam("GroupBy", groupBy);
        }
        if (includeMetadata) {
            resource = resource.queryParam("IncludeMetadata", "true");
        }
        if ((requestAcceptHeader = this.getRequestAcceptHeader()) != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        return (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).get(ClientResponse.class);
    }

    public ClientResponse queryApplicationMetrics(String groupName, String instanceName, String applicationName, String groupBy, boolean includeMetadata) {
        String requestAcceptHeader;
        this.mgr.assertPathParameter("groupName", groupName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        this.mgr.assertPathParameter("applicationName", instanceName);
        WebResource resource = this.mgr.createApplicationMetricResource(groupName, instanceName, applicationName);
        this.logger.fine("queryServiceInstanceMetrics REST URI: " + resource.getURI());
        if (groupBy != null) {
            resource = resource.queryParam("GroupBy", groupBy);
        }
        if (includeMetadata) {
            resource = resource.queryParam("IncludeMetadata", "true");
        }
        if ((requestAcceptHeader = this.getRequestAcceptHeader()) != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        return (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).get(ClientResponse.class);
    }

    public ClientResponse queryApplicationMetrics(String groupName, String instanceName, String applicationName, String metricName, String groupBy, boolean includeMetadata) {
        String requestAcceptHeader;
        this.mgr.assertPathParameter("groupName", groupName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        this.mgr.assertPathParameter("applicationName", instanceName);
        this.mgr.assertPathParameter("metricName", metricName);
        WebResource resource = this.mgr.createApplicationMetricResource(groupName, instanceName, applicationName, metricName);
        this.logger.fine("queryServiceInstanceMetrics REST URI: " + resource.getURI());
        if (groupBy != null) {
            resource = resource.queryParam("GroupBy", groupBy);
        }
        if (includeMetadata) {
            resource = resource.queryParam("IncludeMetadata", "true");
        }
        if ((requestAcceptHeader = this.getRequestAcceptHeader()) != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        return (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).get(ClientResponse.class);
    }

    public ClientResponse deployLibrary(Library library, InputStream libArchive) {
        this.mgr.assertPathParameter("groupName", library.getDomainName());
        this.mgr.assertPathParameter("instanceName", library.getInstanceName());
        WebResource resource = this.mgr.createLibraryResource(library.getDomainName(), library.getInstanceName());
        this.logger.fine("deployLibrary REST URI: " + resource.getURI());
        InputStream libDescriptor = this.marshalLibrary(library);
        FormDataMultiPart multiPart = null;
        multiPart = libArchive != null ? new FormDataMultiPart().field("archive", (Object)libArchive, MediaType.APPLICATION_OCTET_STREAM_TYPE).field("descriptor", (Object)libDescriptor, MediaType.APPLICATION_OCTET_STREAM_TYPE) : new FormDataMultiPart().field("descriptor", (Object)libDescriptor, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        return (ClientResponse)((WebResource.Builder)resource.type("multipart/form-data").accept(new String[]{"application/xml", "text/plain"})).post(ClientResponse.class, (Object)multiPart);
    }

    public ClientResponse redeployLibrary(Library library, InputStream libArchive) {
        this.mgr.assertPathParameter("groupName", library.getDomainName());
        this.mgr.assertPathParameter("instanceName", library.getInstanceName());
        this.mgr.assertPathParameter("libraryName", library.getName());
        WebResource resource = this.mgr.createLibraryResource(library.getDomainName(), library.getInstanceName(), library.getVersionedName());
        this.logger.fine("redeployLibrary REST URI: " + resource.getURI());
        InputStream libDescriptor = this.marshalLibrary(library);
        FormDataMultiPart multiPart = null;
        multiPart = libArchive != null ? new FormDataMultiPart().field("archive", (Object)libArchive, MediaType.APPLICATION_OCTET_STREAM_TYPE).field("descriptor", (Object)libDescriptor, MediaType.APPLICATION_OCTET_STREAM_TYPE) : new FormDataMultiPart().field("descriptor", (Object)libDescriptor, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        return (ClientResponse)((WebResource.Builder)resource.type("multipart/form-data").accept(new String[]{"application/xml", "text/plain"})).put(ClientResponse.class, (Object)multiPart);
    }

    public ClientResponse undeployLibrary(Library library) {
        this.mgr.assertPathParameter("groupName", library.getDomainName());
        this.mgr.assertPathParameter("instanceName", library.getInstanceName());
        this.mgr.assertPathParameter("libraryName", library.getName());
        this.mgr.assertPathParameter("libraryName", library.getVersionedName());
        WebResource resource = this.mgr.createLibraryResource(library.getDomainName(), library.getInstanceName(), library.getVersionedName());
        this.logger.fine("undeployLibrary REST URI: " + resource.getURI());
        return (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).delete(ClientResponse.class);
    }

    public ClientResponse describeLibrary(String domainName, String instanceName, String libName, String specVersion, String implVersion) {
        this.mgr.assertPathParameter("groupName", domainName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        this.mgr.assertPathParameter("libraryName", libName);
        WebResource resource = this.mgr.createLibraryResource(domainName, instanceName, Helper.getVersionedLibraryName(libName, specVersion, implVersion));
        this.logger.fine("describeLibrary REST URI: " + resource.getURI());
        String requestAcceptHeader = this.getRequestAcceptHeader();
        if (requestAcceptHeader != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        return (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).get(ClientResponse.class);
    }

    public ClientResponse listLibraries(String domainName, String instanceName) {
        this.mgr.assertPathParameter("groupName", domainName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        WebResource resource = this.mgr.createLibraryResource(domainName, instanceName);
        this.logger.fine("listLibrary REST URI: " + resource.getURI());
        String requestAcceptHeader = this.getRequestAcceptHeader();
        if (requestAcceptHeader != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        return (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).get(ClientResponse.class);
    }

    public ClientResponse getReferencingApplicationNames(Library library) {
        this.mgr.assertPathParameter("groupName", library.getDomainName());
        this.mgr.assertPathParameter("instanceName", library.getInstanceName());
        this.mgr.assertPathParameter("libraryName", library.getName());
        WebResource resource = this.mgr.createLibraryRefrencesResource(library.getDomainName(), library.getInstanceName(), library.getVersionedName());
        this.logger.fine("getReferencingApplicationNames REST URI: " + resource.getURI());
        String requestAcceptHeader = this.getRequestAcceptHeader();
        if (requestAcceptHeader != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        return (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).get(ClientResponse.class);
    }

    private InputStream marshalApp(Application app) {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Application.class});
            Marshaller m = jc.createMarshaller();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            m.marshal((Object)app, (OutputStream)os);
            byte[] bytes = os.toByteArray();
            String str = new String(bytes);
            if (this.mgr.simv1) {
                str = XmlUtil.unfixXml(str);
            }
            return new ByteArrayInputStream(str.getBytes());
        }
        catch (JAXBException e) {
            throw new InvalidDescriptorException("Failed to marshal Application instance.", e);
        }
    }

    private InputStream marshalLibrary(Library lib) {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Library.class});
            Marshaller m = jc.createMarshaller();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            m.marshal((Object)lib, (OutputStream)os);
            byte[] bytes = os.toByteArray();
            String str = new String(bytes);
            if (this.mgr.simv1) {
                str = XmlUtil.unfixXml(str);
            }
            return new ByteArrayInputStream(str.getBytes());
        }
        catch (JAXBException e) {
            throw new InvalidDescriptorException("Failed to marshal Library instance.", e);
        }
    }

    private String getApplicationStateXmlValue(ApplicationState state) {
        String value = null;
        try {
            value = ApplicationState.class.getField(state.name()).getAnnotation(XmlEnumValue.class).value();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return value;
    }

    private String getRequestAcceptHeader() {
        return this.request == null ? null : this.request.getHeader("Accept");
    }

    public ClientResponse getWelcomePage() {
        WebResource resource = this.mgr.createWelcomePageResource();
        this.logger.fine("getWelcomePage REST URI: " + resource.getURI());
        String requestAcceptHeader = this.getRequestAcceptHeader();
        if (requestAcceptHeader != null) {
            return (ClientResponse)resource.accept(new String[]{requestAcceptHeader}).get(ClientResponse.class);
        }
        ClientResponse response = (ClientResponse)resource.accept(new String[]{"text/html", "text/plain"}).get(ClientResponse.class);
        return response;
    }

    public ClientResponse queryServiceInstanceLogs(String groupName, String instanceName, Map<String, List<String>> queryParams) {
        this.mgr.assertPathParameter("groupName", groupName);
        this.mgr.assertPathParameter("instanceName", instanceName);
        WebResource resource = this.mgr.createInstanceResource(groupName, instanceName).path("log").path("query");
        if (queryParams != null) {
            for (String key : queryParams.keySet()) {
                for (String value : queryParams.get(key)) {
                    resource = resource.queryParam(key, value);
                }
            }
        }
        this.logger.fine("executeLogQuery REST URI: " + resource.getURI());
        return (ClientResponse)((WebResource.Builder)resource.type("application/xml").accept(new String[]{"application/xml", "text/plain"})).get(ClientResponse.class);
    }

    public ClientResponse restartService(String identityDomain, String serviceName, boolean forceShutdown, Long serverRestartTimeout) {
        this.mgr.assertPathParameter("groupName", identityDomain);
        this.mgr.assertPathParameter("instanceName", serviceName);
        WebResource resource = this.mgr.createRestartServiceResource(identityDomain, serviceName);
        resource = resource.queryParam("ForceRestart", String.valueOf(forceShutdown));
        if (serverRestartTimeout != null) {
            resource = resource.queryParam("ServerRestartTimeout", String.valueOf(serverRestartTimeout));
        }
        return (ClientResponse)resource.accept(new String[]{"application/xml"}).put(ClientResponse.class);
    }
}

