/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.internal;

import com.sun.jersey.api.client.ClientResponse;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import oracle.cloud.paas.api.JobManager;
import oracle.cloud.paas.api.JobQuery;
import oracle.cloud.paas.api.JobQueryBuilder;
import oracle.cloud.paas.exception.ManagerException;
import oracle.cloud.paas.internal.AbstractManagerImpl;
import oracle.cloud.paas.internal.JobQueryParameters;
import oracle.cloud.paas.internal.TrustTokenProvider;
import oracle.cloud.paas.model.Job;
import oracle.cloud.paas.model.Jobs;
import oracle.cloud.paas.model.Log;
import oracle.cloud.paas.model.Logs;
import oracle.cloud.paas.nls.MessageBundleUtil;

public class JobManagerImpl
extends AbstractManagerImpl
implements JobManager,
JobQueryParameters {
    public JobManagerImpl(URL url, String identityDomain, String user, String password, Map<String, Object> clientProperties) {
        super(url, identityDomain, user, password, clientProperties);
    }

    public JobManagerImpl(URL url, String identityDomain, String user, TrustTokenProvider provider, Map<String, Object> clientProperties) {
        super(url, identityDomain, user, provider, clientProperties);
    }

    @Override
    public List<Job> listJobs() {
        ClientResponse response = this.getPublicManagerHelper().listJobs(null);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return ((Jobs)response.getEntity(Jobs.class)).getJobs();
        }
        throw this.convertClientResponseToException("listJobs", response);
    }

    private List<Job> listJobs(Map<String, String> filter) {
        ClientResponse response = this.getPublicManagerHelper().listJobs(filter);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return ((Jobs)response.getEntity(Jobs.class)).getJobs();
        }
        throw this.convertClientResponseToException("listJobs", response);
    }

    @Override
    public List<Job> listJobs(JobQuery query) {
        return this.listJobs(query.getFilter());
    }

    @Override
    public List<Job> listJobs(String groupName, String instanceName) {
        JobQueryBuilder builder = JobQueryBuilder.createBuilder();
        if (groupName != null) {
            builder.identityDomain(groupName);
        }
        if (instanceName != null) {
            builder.service(instanceName);
        }
        return this.listJobs(builder.build());
    }

    @Override
    public List<Job> listJobs(String groupName, String instanceName, String applicationName) {
        JobQueryBuilder builder = JobQueryBuilder.createBuilder();
        if (groupName != null) {
            builder.identityDomain(groupName);
        }
        if (instanceName != null) {
            builder.service(instanceName);
        }
        if (applicationName != null) {
            builder.application(applicationName);
        }
        return this.listJobs(builder.build());
    }

    @Override
    public Job describeJob(String jobID) {
        ClientResponse response = this.getPublicManagerHelper().describeJob(jobID);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return (Job)response.getEntity(Job.class);
        }
        throw this.convertClientResponseToException("describeJob", response);
    }

    @Override
    public List<Log> listJobLogs(String jobID) {
        ClientResponse response = this.getPublicManagerHelper().listJobLogs(jobID);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return ((Logs)response.getEntity(Logs.class)).getLogs();
        }
        throw this.convertClientResponseToException("listJobLogs", response);
    }

    @Override
    public void fetchJobLog(String jobID, String logName, OutputStream out) {
        ClientResponse response = this.getPublicManagerHelper().fetchJobLog(jobID, logName);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            try {
                byte[] log = ((String)response.getEntity(String.class)).getBytes();
                out.write(log, 0, log.length);
            }
            catch (Exception e) {
                throw new ManagerException(MessageBundleUtil.msg.getString("OC-PAAS-10008", jobID, logName, e.getMessage()), e);
            }
        } else {
            throw this.convertClientResponseToException("fetchJobLog", response);
        }
    }
}

